/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.node.local;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.concurrent.Callable;
import org.jppf.classloader.AbstractClassLoaderConnection;
import org.jppf.classloader.AbstractJPPFClassLoader;
import org.jppf.classloader.JPPFLocalClassLoader;
import org.jppf.server.node.AbstractClassLoaderManager;
import org.jppf.server.node.AbstractCommonNode;
import org.jppf.server.node.JPPFContainer;
import org.jppf.server.node.JPPFNode;
import org.jppf.server.node.local.JPPFLocalContainer;
import org.jppf.server.node.local.JPPFLocalNode;

class LocalClassLoaderManager
extends AbstractClassLoaderManager<JPPFLocalNode> {
    LocalClassLoaderManager(JPPFLocalNode node) {
        super((JPPFNode)node);
    }

    protected AbstractJPPFClassLoader createClassLoader() {
        PrivilegedAction<AbstractJPPFClassLoader> pa = new PrivilegedAction<AbstractJPPFClassLoader>(){

            @Override
            public AbstractJPPFClassLoader run() {
                AbstractClassLoaderConnection<?> connection = ((JPPFLocalNode)LocalClassLoaderManager.this.node).getClassLoaderConnection();
                return new JPPFLocalClassLoader(connection, this.getClass().getClassLoader());
            }
        };
        return AccessController.doPrivileged(pa);
    }

    protected JPPFContainer newJPPFContainer(List<String> uuidPath, AbstractJPPFClassLoader cl, boolean clientAccess) throws Exception {
        return new JPPFLocalContainer((AbstractCommonNode)this.node, uuidPath, cl, clientAccess);
    }

    protected Callable<AbstractJPPFClassLoader> newClassLoaderCreator(final List<String> uuidPath, Object ... params) {
        return new Callable<AbstractJPPFClassLoader>(){

            @Override
            public AbstractJPPFClassLoader call() {
                PrivilegedAction<AbstractJPPFClassLoader> pa = new PrivilegedAction<AbstractJPPFClassLoader>(){

                    @Override
                    public AbstractJPPFClassLoader run() {
                        AbstractJPPFClassLoader parent = LocalClassLoaderManager.this.getClassLoader();
                        return new JPPFLocalClassLoader(parent.getConnection(), (ClassLoader)parent, uuidPath);
                    }
                };
                return AccessController.doPrivileged(pa);
            }
        };
    }
}

