/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.node.remote;

import org.jppf.JPPFNodeReconnectionNotification;
import org.jppf.comm.recovery.HeartbeatConnection;
import org.jppf.comm.recovery.HeartbeatConnectionEvent;
import org.jppf.comm.recovery.HeartbeatConnectionListener;
import org.jppf.node.connection.ConnectionReason;
import org.jppf.node.connection.DriverConnectionInfo;
import org.jppf.server.node.JPPFNode;
import org.jppf.server.node.remote.RemoteNodeConnection;
import org.jppf.server.node.remote.RemoteNodeIO;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.TypedProperties;
import org.jppf.utils.concurrent.ThreadUtils;
import org.jppf.utils.configuration.JPPFProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRemoteNode
extends JPPFNode
implements HeartbeatConnectionListener {
    private static Logger log = LoggerFactory.getLogger(AbstractRemoteNode.class);
    private static boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    private HeartbeatConnection recoveryConnection;
    private final DriverConnectionInfo connectionInfo;

    public AbstractRemoteNode(String uuid, TypedProperties configuration, DriverConnectionInfo connectionInfo) {
        super(uuid, configuration);
        this.connectionInfo = connectionInfo;
        this.initClassLoaderManager();
    }

    protected abstract void initClassLoaderManager();

    public void initDataChannel() throws Exception {
        this.nodeConnection = new RemoteNodeConnection(this.connectionInfo, this.serializer);
        this.nodeConnection.init();
        if (this.nodeIO == null) {
            this.nodeIO = new RemoteNodeIO(this);
        }
        if (((Boolean)this.configuration.get(JPPFProperties.RECOVERY_ENABLED)).booleanValue() && this.recoveryConnection == null) {
            if (debugEnabled) {
                log.debug("Initializing recovery");
            }
            this.recoveryConnection = new HeartbeatConnection(65527, this.uuid, this.connectionInfo.getHost(), this.connectionInfo.getPort(), this.connectionInfo.isSecure());
            this.recoveryConnection.addClientConnectionListener((HeartbeatConnectionListener)this);
            ThreadUtils.startThread((Runnable)this.recoveryConnection, (String)"HeartbeatConnection");
        }
    }

    public void closeDataChannel() throws Exception {
        HeartbeatConnection tmp;
        if (debugEnabled) {
            log.debug("closing data channel: nodeConnection=" + this.nodeConnection + ", recoveryConnection=" + this.recoveryConnection);
        }
        if (this.nodeConnection != null) {
            this.nodeConnection.close();
        }
        if (this.recoveryConnection != null && (tmp = this.recoveryConnection) != null) {
            this.recoveryConnection = null;
            tmp.close();
        }
    }

    public void heartbeatConnectionFailed(HeartbeatConnectionEvent event) {
        try {
            if (debugEnabled) {
                log.debug("recovery connection failed, attempting to reconnect this node");
            }
            this.reconnectionNotification = new JPPFNodeReconnectionNotification("The heartbeat mechanism failed to receive a message from the server", null, ConnectionReason.HEARTBEAT_FAILURE);
            this.getExecutionManager().cancelAllTasks(false, false);
            this.closeDataChannel();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public boolean isLocal() {
        return false;
    }
}

