/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.node.remote;

import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.jppf.classloader.AbstractJPPFClassLoader;
import org.jppf.comm.socket.SocketWrapper;
import org.jppf.io.DataLocation;
import org.jppf.io.IOHelper;
import org.jppf.io.InputSource;
import org.jppf.io.SocketWrapperInputSource;
import org.jppf.node.protocol.TaskBundle;
import org.jppf.server.node.AbstractCommonNode;
import org.jppf.server.node.JPPFContainer;
import org.jppf.server.node.ObjectDeserializationTask;
import org.jppf.server.node.remote.RemoteNodeConnection;
import org.jppf.utils.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPPFRemoteContainer
extends JPPFContainer {
    private static Logger log = LoggerFactory.getLogger(JPPFRemoteContainer.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private static boolean traceEnabled = log.isTraceEnabled();
    private RemoteNodeConnection nodeConnection;

    public JPPFRemoteContainer(AbstractCommonNode node, List<String> uuidPath, AbstractJPPFClassLoader classLoader, boolean clientAccess) throws Exception {
        super(node, uuidPath, classLoader, clientAccess);
        this.nodeConnection = (RemoteNodeConnection)node.getNodeConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deserializeObjects(Object[] list, int count, ExecutorService executor) throws Throwable {
        if (debugEnabled) {
            log.debug("deserializing {} objects", (Object)count);
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.classLoader);
            ExecutorCompletionService completionService = new ExecutorCompletionService(executor, new ArrayBlockingQueue(count));
            SocketWrapperInputSource is = new SocketWrapperInputSource((SocketWrapper)this.nodeConnection.getChannel());
            for (int i = 0; i < count; ++i) {
                DataLocation dl = IOHelper.readData((InputSource)is);
                if (traceEnabled) {
                    log.trace("i = {}, read data size = {}", (Object)i, (Object)(dl == null ? -1 : dl.getSize()));
                }
                completionService.submit(new ObjectDeserializationTask((JPPFContainer)this, (TaskBundle)list[0], dl, i));
            }
            Throwable t = null;
            int throwableCount = 0;
            for (int i = 0; i < count; ++i) {
                Future f = completionService.take();
                ObjectDeserializationTask task = (ObjectDeserializationTask)f.get();
                Object o = task.getObject();
                if (o instanceof Throwable) {
                    ++throwableCount;
                    if (t == null) {
                        t = (Throwable)o;
                    }
                }
                list[task.getIndex() + 1] = o;
            }
            if (t != null) {
                if (debugEnabled) {
                    log.debug("tasks deserialization resulted in {} errors, first throwable = {}", (Object)throwableCount, (Object)ExceptionUtils.getMessage(t));
                }
                throw t;
            }
            int n = 0;
            return n;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    public void setNodeConnection(RemoteNodeConnection nodeConnection) {
        this.nodeConnection = nodeConnection;
    }
}

