/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.node.remote;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.concurrent.Callable;
import org.jppf.classloader.AbstractJPPFClassLoader;
import org.jppf.classloader.JPPFClassLoader;
import org.jppf.server.node.AbstractClassLoaderManager;
import org.jppf.server.node.AbstractCommonNode;
import org.jppf.server.node.JPPFContainer;
import org.jppf.server.node.JPPFNode;
import org.jppf.server.node.remote.JPPFRemoteContainer;
import org.jppf.server.node.remote.JPPFRemoteNode;
import org.jppf.utils.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteClassLoaderManager
extends AbstractClassLoaderManager<JPPFRemoteNode> {
    private static Logger log = LoggerFactory.getLogger(RemoteClassLoaderManager.class);
    private static boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);

    RemoteClassLoaderManager(JPPFRemoteNode node) {
        super((JPPFNode)node);
    }

    protected AbstractJPPFClassLoader createClassLoader() {
        if (debugEnabled) {
            log.debug("Initializing classloader");
        }
        return ((JPPFRemoteNode)this.node).getJPPFClassLoader();
    }

    protected JPPFContainer newJPPFContainer(List<String> uuidPath, AbstractJPPFClassLoader cl, boolean clientAccess) throws Exception {
        return new JPPFRemoteContainer((AbstractCommonNode)this.node, uuidPath, cl, clientAccess);
    }

    protected Callable<AbstractJPPFClassLoader> newClassLoaderCreator(List<String> uuidPath, Object ... params) {
        return () -> {
            PrivilegedAction<AbstractJPPFClassLoader> pa = () -> {
                AbstractJPPFClassLoader parent = this.getClassLoader();
                return new JPPFClassLoader(parent.getConnection(), (ClassLoader)parent, uuidPath);
            };
            return AccessController.doPrivileged(pa);
        };
    }
}

