/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.node.remote;

import org.jppf.JPPFNodeReconnectionNotification;
import org.jppf.comm.interceptor.InterceptorHandler;
import org.jppf.comm.socket.SocketClient;
import org.jppf.comm.socket.SocketInitializer;
import org.jppf.comm.socket.SocketWrapper;
import org.jppf.node.AbstractNodeConnection;
import org.jppf.node.connection.ConnectionReason;
import org.jppf.node.connection.DriverConnectionInfo;
import org.jppf.serialization.ObjectSerializer;
import org.jppf.ssl.SSLHelper;
import org.jppf.utils.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteNodeConnection
extends AbstractNodeConnection<SocketWrapper> {
    private static Logger log = LoggerFactory.getLogger(RemoteNodeConnection.class);
    private static boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    private SocketInitializer socketInitializer = SocketInitializer.Factory.newInstance();
    private final ObjectSerializer serializer;
    private final DriverConnectionInfo connectionInfo;

    public RemoteNodeConnection(DriverConnectionInfo connectionInfo, ObjectSerializer serializer) {
        this.connectionInfo = connectionInfo;
        this.serializer = serializer;
    }

    public void init() throws Exception {
        this.lock.lock();
        try {
            if (debugEnabled) {
                log.debug("Initializing socket");
            }
            this.channel = new SocketClient();
            ((SocketWrapper)this.channel).setHost(this.connectionInfo.getHost());
            ((SocketWrapper)this.channel).setPort(this.connectionInfo.getPort());
            ((SocketWrapper)this.channel).setSerializer(this.serializer);
            if (debugEnabled) {
                log.debug("end socket client initialization");
            }
            System.out.println("Attempting connection to the node server at " + this.connectionInfo.getHost() + ':' + this.connectionInfo.getPort());
            if (!this.socketInitializer.initialize((SocketWrapper)this.channel)) {
                if (debugEnabled) {
                    log.debug("socket initializer failed");
                }
                throw new JPPFNodeReconnectionNotification("the JPPF node job channel could not reconnect to the driver", null, ConnectionReason.JOB_CHANNEL_INIT_ERROR);
            }
            if (!InterceptorHandler.invokeOnConnect((SocketWrapper)((SocketWrapper)this.channel))) {
                throw new JPPFNodeReconnectionNotification("connection denied by interceptor", null, ConnectionReason.JOB_CHANNEL_INIT_ERROR);
            }
            System.out.println("Reconnected to the node server");
            if (debugEnabled) {
                log.debug("sending channel identifier");
            }
            ((SocketWrapper)this.channel).writeInt(65532);
            if (this.connectionInfo.isSecure()) {
                this.channel = SSLHelper.createSSLClientConnection((SocketWrapper)((SocketWrapper)this.channel));
            }
            if (debugEnabled) {
                log.debug("end socket initializer");
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void close() throws Exception {
        this.lock.lock();
        try {
            if (this.channel != null) {
                SocketWrapper tmp = (SocketWrapper)this.channel;
                this.channel = null;
                tmp.close();
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

