/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.peer;

import java.net.ConnectException;
import java.net.InetAddress;
import org.jppf.JPPFException;
import org.jppf.comm.discovery.JPPFConnectionInformation;
import org.jppf.comm.interceptor.InterceptorHandler;
import org.jppf.comm.socket.SocketChannelClient;
import org.jppf.comm.socket.SocketInitializer;
import org.jppf.comm.socket.SocketWrapper;
import org.jppf.utils.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractPeerConnectionHandler
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(AbstractPeerConnectionHandler.class);
    private static final boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    final boolean secure;
    final JPPFConnectionInformation connectionInfo;
    SocketChannelClient socketClient = null;
    SocketInitializer socketInitializer = SocketInitializer.Factory.newInstance();
    final String name;
    Runnable onCloseAction;
    boolean printConnectionMessage;
    final String connectionUuid;
    final int channelIdentifier;

    public AbstractPeerConnectionHandler(String peerNameBase, JPPFConnectionInformation connectionInfo, boolean secure, String connectionUuid, int channelIdentifier) {
        if (peerNameBase == null || peerNameBase.isEmpty()) {
            throw new IllegalArgumentException("peerName is blank");
        }
        if (connectionInfo == null) {
            throw new IllegalArgumentException("connectionInfo is null");
        }
        this.connectionInfo = connectionInfo;
        this.secure = secure;
        this.connectionUuid = connectionUuid;
        this.name = peerNameBase;
        this.channelIdentifier = channelIdentifier;
    }

    public synchronized void init() throws Exception {
        String msg;
        if (this.socketClient == null) {
            this.socketClient = this.initSocketChannel();
        }
        String cname = String.format("%s@%s:%d", this.name, this.socketClient.getHost(), this.socketClient.getPort());
        if (this.printConnectionMessage) {
            msg = "Attempting connection to remote peer " + cname;
            log.info(msg);
            System.out.println(msg);
        }
        if (!this.socketInitializer.initialize((SocketWrapper)this.socketClient)) {
            throw new ConnectException("could not connect to peer " + cname);
        }
        if (!InterceptorHandler.invokeOnConnect((SocketWrapper)this.socketClient)) {
            throw new JPPFException("peer connection denied by interceptor");
        }
        if (debugEnabled) {
            log.debug("Connected to peer {}, sending channel identifier", (Object)cname);
        }
        this.socketClient.writeInt(this.channelIdentifier);
        if (this.printConnectionMessage) {
            msg = "Reconnected to remote peer " + cname;
            log.info(msg);
            System.out.println(msg);
        }
        this.postInit();
    }

    @Override
    public abstract void close();

    abstract void postInit() throws Exception;

    private SocketChannelClient initSocketChannel() throws Exception {
        String host = this.connectionInfo.host == null || this.connectionInfo.host.isEmpty() ? "localhost" : this.connectionInfo.host;
        host = InetAddress.getByName(host).getHostName();
        int port = this.secure ? this.connectionInfo.sslServerPorts[0] : this.connectionInfo.serverPorts[0];
        return new SocketChannelClient(host, port, false);
    }
}

