/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.peer;

import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import org.jppf.JPPFRuntimeException;
import org.jppf.comm.discovery.JPPFConnectionInformation;
import org.jppf.nio.NioContext;
import org.jppf.server.nio.client.AsyncClientContext;
import org.jppf.server.nio.client.AsyncClientNioServer;
import org.jppf.server.peer.AbstractPeerConnectionHandler;
import org.jppf.utils.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AsyncPeerNode
extends AbstractPeerConnectionHandler {
    private static final Logger log = LoggerFactory.getLogger(AsyncPeerNode.class);
    private static final boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    private final AsyncClientNioServer server;
    private AsyncClientContext context;

    public AsyncPeerNode(String peerNameBase, JPPFConnectionInformation connectionInfo, AsyncClientNioServer server, boolean secure, String connectionUuid) {
        super(peerNameBase, connectionInfo, secure, connectionUuid, 65532);
        this.server = server;
        this.printConnectionMessage = true;
    }

    @Override
    void postInit() throws Exception {
        try {
            SocketChannel socketChannel = this.socketClient.getChannel();
            this.socketClient.setChannel(null);
            socketChannel.configureBlocking(false);
            this.server.accept(null, socketChannel, null, this.secure, true, new Object[0]);
            SelectionKey key = socketChannel.keyFor(this.server.getSelector());
            this.context = (AsyncClientContext)((Object)key.attachment());
            this.context.setPeer(true);
            this.context.setConnectionUuid(this.connectionUuid);
            this.context.setOnCloseAction(this.onCloseAction);
            if (debugEnabled) {
                log.debug("registered peer client channel " + (Object)((Object)this.context));
            }
            if (this.secure) {
                this.context.setSsl(true);
                this.server.configurePeerSSL((NioContext)this.context);
            }
            this.server.getMessageHandler().sendPeerHandshake(this.context);
            this.socketClient = null;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new JPPFRuntimeException((Throwable)e);
        }
    }

    @Override
    public void close() {
        if (debugEnabled) {
            log.debug("closing {}, context={} ", (Object)this, (Object)this.context);
        }
        if (this.context != null) {
            this.context.setOnCloseAction(null);
            this.context.handleException(null);
            this.context = null;
        }
    }
}

