/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.peer;

import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import org.jppf.JPPFRuntimeException;
import org.jppf.classloader.JPPFResourceWrapper;
import org.jppf.classloader.ResourceIdentifier;
import org.jppf.comm.discovery.JPPFConnectionInformation;
import org.jppf.nio.ClassLoaderNioMessage;
import org.jppf.nio.NioContext;
import org.jppf.server.nio.classloader.client.AsyncClientClassContext;
import org.jppf.server.nio.classloader.client.AsyncClientClassNioServer;
import org.jppf.server.peer.AbstractPeerConnectionHandler;
import org.jppf.utils.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AsyncPeerResourceProvider
extends AbstractPeerConnectionHandler {
    private static final Logger log = LoggerFactory.getLogger(AsyncPeerResourceProvider.class);
    private static final boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    private final AsyncClientClassNioServer server;
    private AsyncClientClassContext context;

    public AsyncPeerResourceProvider(String peerNameBase, JPPFConnectionInformation connectionInfo, AsyncClientClassNioServer server, boolean secure, String connectionUuid) {
        super(peerNameBase, connectionInfo, secure, connectionUuid, 65533);
        this.server = server;
    }

    @Override
    void postInit() throws Exception {
        try {
            SocketChannel socketChannel = this.socketClient.getChannel();
            this.socketClient.setChannel(null);
            socketChannel.configureBlocking(false);
            this.server.accept(null, socketChannel, null, this.secure, true, new Object[0]);
            SelectionKey key = socketChannel.keyFor(this.server.getSelector());
            this.context = (AsyncClientClassContext)((Object)key.attachment());
            this.context.setPeer(true);
            this.context.setConnectionUuid(this.connectionUuid);
            if (debugEnabled) {
                log.debug("registered class server channel {}", (Object)this.context);
            }
            JPPFResourceWrapper resource = new JPPFResourceWrapper();
            resource.setState(JPPFResourceWrapper.State.NODE_INITIATION);
            String uuid = this.server.getDriver().getUuid();
            resource.setData(ResourceIdentifier.NODE_UUID, (Object)uuid);
            resource.setData(ResourceIdentifier.PEER, (Object)Boolean.TRUE);
            resource.setProviderUuid(uuid);
            if (this.secure) {
                this.context.setSsl(true);
                this.server.configurePeerSSL((NioContext)this.context);
            }
            ClassLoaderNioMessage message = this.context.serializeResource(resource);
            this.context.offerMessageToSend(message);
            if (debugEnabled) {
                log.debug("sent initiation request {} for {}", (Object)resource, (Object)this.context);
            }
            this.socketClient = null;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new JPPFRuntimeException((Throwable)e);
        }
    }

    @Override
    public void close() {
        if (debugEnabled) {
            log.debug("closing {}, context={} ", (Object)this, (Object)this.context);
        }
        if (this.context != null) {
            this.context.setOnCloseAction(null);
            this.context.handleException(null);
            this.context = null;
        }
    }
}

