/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.peer;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jppf.comm.discovery.JPPFConnectionInformation;
import org.jppf.server.JPPFDriver;
import org.jppf.server.peer.AbstractPeerConnectionHandler;
import org.jppf.server.peer.AsyncPeerNode;
import org.jppf.server.peer.AsyncPeerResourceProvider;
import org.jppf.server.peer.PeerDiscoveryThread;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.concurrent.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPPFPeerInitializer
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(JPPFPeerInitializer.class);
    private static final boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    static final AtomicInteger SEQUENCE = new AtomicInteger(0);
    private final String peerName;
    private final JPPFConnectionInformation connectionInfo;
    private final boolean secure;
    private final boolean fromDiscovery;
    private AbstractPeerConnectionHandler provider;
    private AbstractPeerConnectionHandler node;
    private final AtomicBoolean connecting = new AtomicBoolean(false);
    final String connectionUuid;
    private final JPPFDriver driver;

    public JPPFPeerInitializer(JPPFDriver driver, String peerName, JPPFConnectionInformation connectionInfo, boolean secure) {
        this(driver, peerName, connectionInfo, secure, false);
    }

    public JPPFPeerInitializer(JPPFDriver driver, String peerName, JPPFConnectionInformation connectionInfo, boolean secure, boolean fromDiscovery) {
        if (peerName == null || peerName.isEmpty()) {
            throw new IllegalArgumentException("peerName is blank");
        }
        if (connectionInfo == null) {
            throw new IllegalArgumentException("connectionInfo is null");
        }
        this.driver = driver;
        this.peerName = peerName;
        this.connectionInfo = connectionInfo;
        this.secure = secure;
        this.fromDiscovery = fromDiscovery;
        this.connectionUuid = driver.getUuid() + '-' + SEQUENCE.incrementAndGet();
        log.debug("created new peer initializer {}", (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void run() {
        if (debugEnabled) {
            log.debug("start initialization of peer [{}]", (Object)this.peerName);
        }
        try {
            if (this.connecting.compareAndSet(false, true)) {
                if (this.provider == null) {
                    this.provider = new AsyncPeerResourceProvider(this.peerName, this.connectionInfo, this.driver.getAsyncClientClassServer(), this.secure, this.connectionUuid);
                }
                this.provider.init();
                if (this.node == null) {
                    this.node = new AsyncPeerNode(this.peerName, this.connectionInfo, this.driver.getAsyncClientNioServer(), this.secure, this.connectionUuid);
                }
                this.node.onCloseAction = () -> this.start();
                this.node.init();
            }
        }
        catch (Exception e) {
            PeerDiscoveryThread pdt;
            log.error(e.getMessage(), (Throwable)e);
            if (this.provider != null) {
                this.provider.close();
                this.provider = null;
            }
            if (this.node != null) {
                this.node.close();
                this.node = null;
            }
            if (this.fromDiscovery && (pdt = this.driver.getInitializer().getPeerDiscoveryThread()) != null) {
                boolean removed = pdt.removeConnectionInformation(this.connectionInfo);
                if (debugEnabled) {
                    log.debug((removed ? "successfully removed " : "failed to remove ") + "{}", (Object)this.connectionInfo);
                }
            }
        }
        finally {
            this.connecting.set(false);
            if (debugEnabled) {
                log.debug("end initialization of peer [{}]", (Object)this.peerName);
            }
        }
    }

    public void start() {
        ThreadUtils.startThread((Runnable)this, (String)String.format("%s[%s]", this.getClass().getSimpleName(), this.peerName));
    }

    public void close() {
        if (this.provider != null) {
            this.provider.close();
            this.provider = null;
        }
        if (this.node != null) {
            this.node.close();
            this.node = null;
        }
    }
}

