/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.peer;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jppf.comm.discovery.JPPFConnectionInformation;
import org.jppf.comm.recovery.HeartbeatConnection;
import org.jppf.comm.recovery.HeartbeatConnectionEvent;
import org.jppf.comm.recovery.HeartbeatConnectionListener;
import org.jppf.server.JPPFDriver;
import org.jppf.server.peer.JPPFPeerInitializer;
import org.jppf.utils.concurrent.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerConnectionPool
implements HeartbeatConnectionListener {
    private static final Logger log = LoggerFactory.getLogger(PeerConnectionPool.class);
    private static final boolean debugEnabled = log.isDebugEnabled();
    private final String peerName;
    private final JPPFConnectionInformation connectionInfo;
    private final boolean secure;
    private final boolean fromDiscovery;
    private int size;
    private final AtomicInteger connectionSequence = new AtomicInteger(0);
    private final List<JPPFPeerInitializer> initializers = new ArrayList<JPPFPeerInitializer>();
    private HeartbeatConnection recoveryConnection;
    private final JPPFDriver driver;

    public PeerConnectionPool(JPPFDriver driver, String peerName, int size, JPPFConnectionInformation connectionInfo, boolean secure, boolean fromDiscovery) {
        this.driver = driver;
        this.peerName = peerName;
        this.size = size < 1 ? 1 : size;
        this.connectionInfo = connectionInfo;
        this.secure = secure;
        this.fromDiscovery = fromDiscovery;
        this.init();
    }

    public String getPeerName() {
        return this.peerName;
    }

    public JPPFConnectionInformation getConnectionInfo() {
        return this.connectionInfo;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public boolean isFromDiscovery() {
        return this.fromDiscovery;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    private void init() {
        this.connectionSequence.set(0);
        for (int i = 1; i <= this.size; ++i) {
            String name = String.format("%s-%d", this.peerName, this.connectionSequence.incrementAndGet());
            JPPFPeerInitializer initializer = new JPPFPeerInitializer(this.driver, name, this.connectionInfo, this.secure, this.fromDiscovery);
            this.initializers.add(initializer);
            initializer.start();
        }
        if (this.connectionInfo.recoveryEnabled) {
            this.initHeartbeat();
        }
    }

    void initHeartbeat() {
        if (this.recoveryConnection == null) {
            if (debugEnabled) {
                log.debug("Initializing recovery");
            }
            this.recoveryConnection = new HeartbeatConnection(65527, this.driver.getUuid(), this.connectionInfo.host, this.connectionInfo.getValidPort(this.secure), this.secure);
            this.recoveryConnection.addClientConnectionListener((HeartbeatConnectionListener)this);
            ThreadUtils.startThread((Runnable)this.recoveryConnection, (String)(this.getPeerName() + "-Heartbeat"));
        }
    }

    public void close() {
        if (debugEnabled) {
            log.debug("Closing peer connection {}", (Object)this);
        }
        if (this.recoveryConnection != null) {
            this.recoveryConnection.close();
            this.recoveryConnection = null;
        }
        for (JPPFPeerInitializer initializer : this.initializers) {
            initializer.close();
        }
        this.initializers.clear();
    }

    public HeartbeatConnection getRecoveryConnection() {
        return this.recoveryConnection;
    }

    public void heartbeatConnectionFailed(HeartbeatConnectionEvent event) {
        this.close();
        this.init();
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + "name=" + this.peerName + ", size=" + this.size + ", secure=" + this.secure + ", connectionInfo=" + this.connectionInfo + ", fromDiscovery=" + this.fromDiscovery + ']';
    }
}

