/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.peer;

import org.jppf.comm.discovery.JPPFConnectionInformation;
import org.jppf.server.JPPFDriver;
import org.jppf.server.peer.PeerConnectionPool;
import org.jppf.utils.TypedProperties;
import org.jppf.utils.configuration.JPPFProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerConnectionPoolHandler {
    private static final Logger log = LoggerFactory.getLogger(PeerConnectionPoolHandler.class);
    private static final boolean debugEnabled = log.isDebugEnabled();
    private final int loadBalanceThreshold;
    private final JPPFDriver driver;

    public PeerConnectionPoolHandler(JPPFDriver driver, TypedProperties config) {
        this.driver = driver;
        int n = (Integer)config.get(JPPFProperties.PEERS_LOAD_BALANCE_THRESHOLD);
        this.loadBalanceThreshold = n < 0 ? 0 : n;
    }

    public PeerConnectionPool newPool(String peerName, int size, JPPFConnectionInformation connectionInfo, boolean secure, boolean fromDiscovery) {
        if (debugEnabled) {
            log.debug("creating PeerConnectionPool with peerName={}, size={}, connectionInfo={}, secure={}, fromDiscovery={}", new Object[]{peerName, size, connectionInfo, secure, fromDiscovery});
        }
        PeerConnectionPool pool = new PeerConnectionPool(this.driver, peerName, size, connectionInfo, secure, fromDiscovery);
        return pool;
    }

    public int getLoadBalanceThreshold() {
        return this.loadBalanceThreshold;
    }
}

