/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.peer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jppf.comm.discovery.IPFilter;
import org.jppf.comm.discovery.JPPFConnectionInformation;
import org.jppf.comm.discovery.JPPFMulticastReceiver;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.TypedProperties;
import org.jppf.utils.concurrent.ThreadSynchronization;
import org.jppf.utils.configuration.JPPFProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerDiscoveryThread
extends ThreadSynchronization
implements Runnable {
    private static Logger log = LoggerFactory.getLogger(PeerDiscoveryThread.class);
    private static boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    private final long removalCleanupInternal;
    private final Set<JPPFConnectionInformation> infoSet = new HashSet<JPPFConnectionInformation>();
    private final AtomicInteger count = new AtomicInteger(0);
    private final JPPFConnectionInformation localInfo;
    private final ConnectionHandler connectionHandler;
    private final IPFilter ipFilter;
    private final Map<String, Long> removalMap = new HashMap<String, Long>();
    private long lastCleanupTime = 0L;
    private final TypedProperties config;

    public PeerDiscoveryThread(TypedProperties config, IPFilter ipFilter, JPPFConnectionInformation localInfo, ConnectionHandler connectionHandler) {
        if (localInfo == null) {
            throw new IllegalArgumentException("localInfo is null");
        }
        if (connectionHandler == null) {
            throw new IllegalArgumentException("connectionHandler is null");
        }
        this.config = config;
        this.connectionHandler = connectionHandler;
        this.ipFilter = ipFilter;
        this.localInfo = localInfo;
        this.removalCleanupInternal = (Long)config.get(JPPFProperties.PEER_DISCOVERY_REMOVAL_CLEANUP_INTERVAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        JPPFMulticastReceiver receiver = null;
        try {
            receiver = new JPPFMulticastReceiver(this.ipFilter);
            while (!this.isStopped()) {
                JPPFConnectionInformation info = receiver.receive();
                PeerDiscoveryThread peerDiscoveryThread = this;
                synchronized (peerDiscoveryThread) {
                    if (this.lastCleanupTime + this.removalCleanupInternal >= System.currentTimeMillis()) {
                        this.cleanRemovals();
                    }
                }
                if (info == null || this.hasConnectionInformation(info) || this.wasRecentlyRemoved(info)) continue;
                if (debugEnabled) {
                    log.debug("Found peer connection information: " + info + ", infoSet=" + this.infoSet);
                }
                info.recoveryEnabled &= ((Boolean)this.config.get(JPPFProperties.PEER_RECOVERY_ENABLED)).booleanValue();
                this.addConnectionInformation(info);
                this.onNewConnection("Peer-" + this.count.incrementAndGet(), info);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (receiver != null) {
                receiver.setStopped(true);
            }
        }
    }

    protected synchronized void onNewConnection(String name, JPPFConnectionInformation info) {
        this.connectionHandler.onNewConnection(name, info);
    }

    protected synchronized boolean hasConnectionInformation(JPPFConnectionInformation info) {
        return this.infoSet.contains(info) || this.isSelf(info);
    }

    public synchronized void addConnectionInformation(JPPFConnectionInformation info) {
        this.infoSet.add(info);
    }

    public synchronized boolean removeConnectionInformation(JPPFConnectionInformation info) {
        this.removalMap.put(info.uuid, System.currentTimeMillis());
        return this.infoSet.remove(info);
    }

    private boolean isSelf(JPPFConnectionInformation info) {
        return info.uuid.equals(this.localInfo.uuid);
    }

    private synchronized void cleanRemovals() {
        long now = System.currentTimeMillis();
        ArrayList<String> toRemove = new ArrayList<String>();
        for (Map.Entry<String, Long> entry : this.removalMap.entrySet()) {
            if (entry.getValue() + this.removalCleanupInternal > now) continue;
            toRemove.add(entry.getKey());
        }
        for (String uuid : toRemove) {
            this.removalMap.remove(uuid);
        }
    }

    private synchronized boolean wasRecentlyRemoved(JPPFConnectionInformation info) {
        return info.uuid == null || this.removalMap.containsKey(info.uuid);
    }

    public Set<JPPFConnectionInformation> getInfoSet() {
        return this.infoSet;
    }

    @FunctionalInterface
    public static interface ConnectionHandler {
        public void onNewConnection(String var1, JPPFConnectionInformation var2);
    }
}

