/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.protocol;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import org.jppf.execute.ExecutorChannel;
import org.jppf.io.DataLocation;
import org.jppf.io.IOHelper;
import org.jppf.nio.NioHelper;
import org.jppf.node.protocol.JPPFDistributedJob;
import org.jppf.node.protocol.JobMetadata;
import org.jppf.node.protocol.JobSLA;
import org.jppf.node.protocol.TaskBundle;
import org.jppf.serialization.ObjectSerializer;
import org.jppf.server.protocol.ServerJobChangeListener;
import org.jppf.server.protocol.ServerJobStatus;
import org.jppf.server.protocol.ServerTaskBundleClient;
import org.jppf.server.protocol.ServerTaskBundleNode;
import org.jppf.server.submission.SubmissionStatus;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.concurrent.SynchronizedReference;
import org.jppf.utils.concurrent.ThreadSynchronization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServerJob
implements JPPFDistributedJob {
    private static final Logger log = LoggerFactory.getLogger(AbstractServerJob.class);
    private static final boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    private static final AtomicLong INSTANCE_COUNT = new AtomicLong(0L);
    protected final long id = INSTANCE_COUNT.incrementAndGet();
    protected volatile ServerJobStatus status = ServerJobStatus.NEW;
    protected final List<Runnable> onDoneList = new ArrayList<Runnable>();
    protected long jobReceivedTime;
    protected transient long queueEntryTime;
    protected final TaskBundle job;
    protected String uuid;
    protected String name;
    protected boolean jobExpired;
    protected boolean pending;
    protected final Lock lock;
    protected final ThreadSynchronization removalCondition = new ThreadSynchronization();
    protected final SynchronizedReference<SubmissionStatus> submissionStatus = new SynchronizedReference((Object)SubmissionStatus.SUBMITTED);
    protected ServerJobChangeListener notificationEmitter;
    protected List<ServerTaskBundleClient> completionBundles;
    DataLocation jobDataLocation;

    protected AbstractServerJob(Lock lock, TaskBundle job) {
        if (lock == null) {
            throw new IllegalArgumentException("lock is null");
        }
        if (job == null) {
            throw new IllegalArgumentException("job is null");
        }
        if (debugEnabled) {
            log.debug("creating ClientJob #" + this.id);
        }
        this.lock = lock;
        this.job = job;
        this.uuid = this.job.getUuid();
        this.name = this.job.getName();
    }

    public TaskBundle getJob() {
        return this.job;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public JobSLA getSLA() {
        return this.job.getSLA();
    }

    public JobMetadata getMetadata() {
        return this.job.getMetadata();
    }

    public void setMetadata(JobMetadata metadata) {
        this.job.setMetadata(metadata);
    }

    public void setSLA(JobSLA sla) {
        this.job.setSLA(sla);
    }

    public boolean isJobExpired() {
        return this.jobExpired;
    }

    public void jobExpired() {
        this.jobExpired = true;
    }

    public boolean isPending() {
        return this.pending;
    }

    public void setPending(boolean pending) {
        boolean oldValue = this.isPending();
        this.pending = pending;
        boolean newValue = this.isPending();
        if (oldValue != newValue) {
            this.fireJobUpdated(true);
        }
    }

    public boolean isSuspended() {
        return this.getSLA().isSuspended();
    }

    public void setSuspended(boolean suspended, boolean requeue) {
        if (this.getSLA().isSuspended() == suspended) {
            return;
        }
        this.getSLA().setSuspended(suspended);
        this.fireJobUpdated(true);
    }

    public void setMaxNodes(int maxNodes) {
        if (maxNodes <= 0) {
            return;
        }
        if (this.getSLA().getMaxNodes() == maxNodes) {
            return;
        }
        this.getSLA().setMaxNodes(maxNodes);
        this.fireJobUpdated(true);
    }

    protected final boolean updateStatus(ServerJobStatus expect, ServerJobStatus newStatus) {
        if (this.status == expect) {
            this.status = newStatus;
            return true;
        }
        return false;
    }

    public ServerJobStatus getStatus() {
        return this.status;
    }

    public boolean isDone() {
        return this.status.compareTo(ServerJobStatus.DONE) >= 0;
    }

    public boolean isCancelled() {
        return this.status.compareTo(ServerJobStatus.CANCELLED) >= 0;
    }

    public boolean setCancelled(boolean mayInterruptIfRunning) {
        if (!this.isSuspended() && this.status.ordinal() > ServerJobStatus.EXECUTING.ordinal()) {
            return false;
        }
        this.status = ServerJobStatus.CANCELLED;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void done() {
        Runnable[] runnables;
        List<Runnable> list = this.onDoneList;
        synchronized (list) {
            runnables = this.onDoneList.toArray(new Runnable[this.onDoneList.size()]);
        }
        NioHelper.getGlobalexecutor().execute(() -> {
            for (Runnable runnable : runnables) {
                runnable.run();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOnDone(Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("runnable is null");
        }
        List<Runnable> list = this.onDoneList;
        synchronized (list) {
            this.onDoneList.add(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOnDone(Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("runnable is null");
        }
        List<Runnable> list = this.onDoneList;
        synchronized (list) {
            this.onDoneList.remove(runnable);
        }
    }

    public long getJobReceivedTime() {
        return this.jobReceivedTime;
    }

    public void setJobReceivedTime(long jobReceivedTime) {
        this.jobReceivedTime = jobReceivedTime;
    }

    public long getQueueEntryTime() {
        return this.queueEntryTime;
    }

    public void setQueueEntryTime(long queueEntryTime) {
        this.queueEntryTime = queueEntryTime;
    }

    public abstract int getTaskCount();

    public int getInitialTaskCount() {
        return this.job.getInitialTaskCount();
    }

    public SubmissionStatus getSubmissionStatus() {
        return (SubmissionStatus)((Object)this.submissionStatus.get());
    }

    public void setSubmissionStatus(SubmissionStatus newStatus) {
        if (!this.submissionStatus.setIfDifferent((Object)newStatus)) {
            return;
        }
        if (newStatus == SubmissionStatus.ENDED) {
            this.done();
        }
    }

    public String getBroadcastUUID() {
        return null;
    }

    public List<ServerTaskBundleClient> getCompletionBundles() {
        this.lock.lock();
        try {
            if (this.completionBundles == null) {
                List<ServerTaskBundleClient> list = Collections.emptyList();
                return list;
            }
            ArrayList<ServerTaskBundleClient> arrayList = new ArrayList<ServerTaskBundleClient>(this.completionBundles);
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void fireJobUpdated(boolean headerUpdated) {
        if (headerUpdated) {
            this.updateJobDataLocation();
        }
        if (this.notificationEmitter != null) {
            this.notificationEmitter.jobUpdated(this, headerUpdated);
        }
    }

    protected void fireJobDispatched(ExecutorChannel<?> channel, ServerTaskBundleNode bundleNode) {
        if (this.notificationEmitter != null) {
            this.notificationEmitter.jobDispatched(this, channel, bundleNode);
        }
    }

    protected void fireJobReturned(ExecutorChannel<?> channel, ServerTaskBundleNode bundleNode) {
        if (this.notificationEmitter != null) {
            this.notificationEmitter.jobReturned(this, channel, bundleNode);
        }
    }

    public Lock getLock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateJobDataLocation() {
        if (!this.isPersistent()) {
            return;
        }
        DataLocation dl = null;
        try {
            this.lock.lock();
            int size = this.jobDataLocation == null ? -1 : this.jobDataLocation.getSize();
            ObjectSerializer ser = IOHelper.getDefaultserializer();
            dl = size <= 0 ? IOHelper.serializeData((Object)this.job, (ObjectSerializer)ser) : (IOHelper.fitsInMemory((int)size) ? IOHelper.serializeDataToMemory((Object)this.job, (ObjectSerializer)ser) : IOHelper.serializeDataToFile((Object)this.job, (ObjectSerializer)ser));
            this.jobDataLocation = dl;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isPersistent() {
        return this.getSLA().getPersistenceSpec().isPersistent();
    }

    public ThreadSynchronization getRemovalCondition() {
        return this.removalCondition;
    }
}

