/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.protocol;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import org.jppf.io.DataLocation;
import org.jppf.node.protocol.BundleParameter;
import org.jppf.node.protocol.TaskBundle;
import org.jppf.server.protocol.AbstractServerJob;
import org.jppf.server.protocol.BundleCompletionListener;
import org.jppf.server.protocol.JPPFJobEndedException;
import org.jppf.server.protocol.ServerJobChangeListener;
import org.jppf.server.protocol.ServerJobStatus;
import org.jppf.server.protocol.ServerTask;
import org.jppf.server.protocol.ServerTaskBundleClient;
import org.jppf.server.protocol.ServerTaskBundleNode;
import org.jppf.server.submission.SubmissionStatus;
import org.jppf.utils.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractServerJobBase
extends AbstractServerJob {
    private static final Logger log = LoggerFactory.getLogger(AbstractServerJobBase.class);
    private static final boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    protected final Map<Integer, ServerTask> tasks = new TreeMap<Integer, ServerTask>();
    protected final List<ServerTaskBundleClient> clientBundles = new ArrayList<ServerTaskBundleClient>();
    protected final Map<Long, ServerTaskBundleNode> dispatchSet = new LinkedHashMap<Long, ServerTaskBundleNode>();
    protected final Map<String, Integer> channelSet = new HashMap<String, Integer>();
    protected Runnable onRequeue;
    protected final DataLocation dataProvider;
    protected final AtomicInteger totalDispatches = new AtomicInteger(0);
    protected final Map<Integer, ServerTask> dependendedOnTasks = new TreeMap<Integer, ServerTask>();

    public AbstractServerJobBase(Lock lock, ServerJobChangeListener notificationEmitter, TaskBundle job, DataLocation dataProvider) {
        super(lock, job);
        this.notificationEmitter = notificationEmitter;
        this.dataProvider = dataProvider;
    }

    public List<ServerTaskBundleClient> getClientBundles() {
        this.lock.lock();
        try {
            ArrayList<ServerTaskBundleClient> arrayList = new ArrayList<ServerTaskBundleClient>(this.clientBundles);
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    public DataLocation getDataProvider() {
        return this.dataProvider;
    }

    @Override
    public int getTaskCount() {
        this.lock.lock();
        try {
            int n = this.tasks.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean merge(List<ServerTask> taskList, boolean after) {
        this.lock.lock();
        try {
            boolean requeue = this.tasks.isEmpty() && !taskList.isEmpty();
            for (ServerTask task : taskList) {
                this.tasks.put(task.getPosition(), task);
            }
            boolean bl = requeue;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jobDispatched(ServerTaskBundleNode bundle) {
        boolean empty;
        if (bundle == null) {
            throw new IllegalArgumentException("bundle is null");
        }
        Map<Long, ServerTaskBundleNode> map = this.dispatchSet;
        synchronized (map) {
            empty = this.dispatchSet.isEmpty();
            this.dispatchSet.put(bundle.getId(), bundle);
            String uuid = bundle.getJob().getUuid();
            Integer n = this.channelSet.get(uuid);
            this.channelSet.put(uuid, n == null ? 1 : n + 1);
        }
        this.totalDispatches.incrementAndGet();
        if (debugEnabled) {
            log.debug("added to dispatch set: {}", (Object)bundle);
        }
        if (empty) {
            this.updateStatus(ServerJobStatus.NEW, ServerJobStatus.EXECUTING);
            this.setSubmissionStatus(SubmissionStatus.EXECUTING);
        }
        this.fireJobDispatched(bundle.getChannel(), bundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jobReturned(ServerTaskBundleNode bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException("bundle is null");
        }
        Map<Long, ServerTaskBundleNode> map = this.dispatchSet;
        synchronized (map) {
            this.dispatchSet.remove(bundle.getId());
            String uuid = bundle.getJob().getUuid();
            Integer n = this.channelSet.get(uuid);
            if (n != null) {
                if (n > 1) {
                    this.channelSet.put(uuid, n - 1);
                } else {
                    this.channelSet.remove(uuid);
                }
            }
        }
        if (debugEnabled) {
            log.debug("removed from dispatch set: {}", (Object)bundle);
        }
        this.fireJobReturned(bundle.getChannel(), bundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasPending() {
        this.lock.lock();
        try {
            for (ServerTaskBundleClient bundle : this.clientBundles) {
                if (bundle.getPendingTasksCount() <= 0) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.lock.unlock();
        }
        return false;
    }

    public void setOnRequeue(Runnable onRequeue) {
        if (this.getSLA().isBroadcastJob()) {
            return;
        }
        this.onRequeue = onRequeue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNbChannels() {
        Map<Long, ServerTaskBundleNode> map = this.dispatchSet;
        synchronized (map) {
            return this.channelSet.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNbDispatches(String uuid) {
        Integer n;
        Map<Long, ServerTaskBundleNode> map = this.dispatchSet;
        synchronized (map) {
            n = this.channelSet.get(uuid);
        }
        return n == null ? 0 : n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNbDispatches() {
        Map<Long, ServerTaskBundleNode> map = this.dispatchSet;
        synchronized (map) {
            return this.dispatchSet.size();
        }
    }

    public int getTotalDispatches() {
        return this.totalDispatches.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerTaskBundleNode getNodeBundle(long id) {
        Map<Long, ServerTaskBundleNode> map = this.dispatchSet;
        synchronized (map) {
            return this.dispatchSet.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ServerTaskBundleNode> getDispatchSet() {
        Map<Long, ServerTaskBundleNode> map = this.dispatchSet;
        synchronized (map) {
            return new LinkedHashSet<ServerTaskBundleNode>(this.dispatchSet.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addBundle(ServerTaskBundleClient bundle) throws JPPFJobEndedException {
        if (bundle == null) {
            throw new IllegalArgumentException("bundle is null");
        }
        this.lock.lock();
        try {
            SubmissionStatus submissionStatus = this.getSubmissionStatus();
            if (debugEnabled) {
                log.debug("submissionStatus={}, adding {} to {}", new Object[]{submissionStatus, bundle, this});
            }
            if (this.hasCompleted()) {
                throw new JPPFJobEndedException("Job " + (Object)((Object)submissionStatus));
            }
            if (log.isTraceEnabled()) {
                AbstractServerJobBase.logTasksPositions(bundle);
            }
            this.clientBundles.add(bundle);
            for (ServerTask task : bundle.getTaskList()) {
                int pos = task.getPosition();
                if (this.tasks.containsKey(pos)) {
                    throw new IllegalStateException(String.format("position %d already in task map for %s, client bundle = %s", pos, this, bundle));
                }
                this.tasks.put(pos, task);
            }
            bundle.addCompletionListener(new BundleCompletionListener(this));
            this.fireJobUpdated(false);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private static void logTasksPositions(ServerTaskBundleClient bundle) {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (ServerTask task : bundle.getTaskList()) {
            if (count > 0) {
                sb.append(", ");
            }
            sb.append(task.getPosition());
            ++count;
        }
        log.trace("tasks positions in client bundle: {}", (Object)sb);
    }

    public boolean hasCompleted() {
        this.lock.lock();
        try {
            SubmissionStatus submissionStatus = this.getSubmissionStatus();
            boolean bl = submissionStatus == SubmissionStatus.COMPLETE || submissionStatus == SubmissionStatus.ENDED;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append('[');
        sb.append("id=").append(this.id);
        sb.append(", job uuid=").append(this.uuid);
        sb.append(", name=").append(this.name);
        sb.append(", submissionStatus=").append(this.submissionStatus.get());
        sb.append(", status=").append((Object)this.status);
        if (this.lock.tryLock()) {
            try {
                sb.append(", taskCount=").append(this.tasks.size());
            }
            finally {
                this.lock.unlock();
            }
        }
        sb.append(", nbBundles=").append(this.getNbBundles());
        sb.append(", jobExpired=").append(this.jobExpired);
        sb.append(", pending=").append(this.pending);
        sb.append(", suspended=").append(this.isSuspended());
        sb.append(']');
        return sb.toString();
    }

    public int getNbBundles() {
        return this.clientBundles.size();
    }

    public boolean isJobGraphAlreadyHandled() {
        return (Boolean)this.job.getParameter((Object)BundleParameter.JOB_GRAPH_ALREADY_HANDLED, (Object)false);
    }
}

