/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.protocol;

import java.util.List;
import org.jppf.server.protocol.AbstractServerJobBase;
import org.jppf.server.protocol.ServerTask;
import org.jppf.server.protocol.ServerTaskBundleClient;
import org.jppf.server.submission.SubmissionStatus;
import org.jppf.utils.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleCompletionListener
implements ServerTaskBundleClient.CompletionListener {
    private static final Logger log = LoggerFactory.getLogger(BundleCompletionListener.class);
    private static final boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    final AbstractServerJobBase serverJob;

    BundleCompletionListener(AbstractServerJobBase serverJob) {
        this.serverJob = serverJob;
    }

    @Override
    public void taskCompleted(ServerTaskBundleClient bundle, List<ServerTask> results) {
        if (bundle == null) {
            throw new IllegalArgumentException("bundle is null");
        }
    }

    @Override
    public void bundleEnded(ServerTaskBundleClient bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException("bundle is null");
        }
        if (debugEnabled) {
            log.debug("bundle ended: {}", (Object)bundle);
        }
        Runnable r = () -> {
            if (debugEnabled) {
                log.debug("handling bundle ended: {}", (Object)bundle);
            }
            SubmissionStatus newStatus = null;
            this.serverJob.lock.lock();
            try {
                if (this.serverJob.getSubmissionStatus() != SubmissionStatus.ENDED) {
                    bundle.removeCompletionListener(this);
                    this.serverJob.clientBundles.remove(bundle);
                    if (this.serverJob.completionBundles != null) {
                        this.serverJob.completionBundles.remove(bundle);
                    }
                    if (this.serverJob.clientBundles.isEmpty() && this.serverJob.tasks.isEmpty()) {
                        newStatus = SubmissionStatus.ENDED;
                        this.serverJob.dependendedOnTasks.clear();
                    }
                } else if (debugEnabled) {
                    log.debug("bundle status is ENDED");
                }
            }
            catch (Exception e) {
                if (debugEnabled) {
                    log.debug(e.getMessage(), (Throwable)e);
                }
            }
            finally {
                this.serverJob.lock.unlock();
            }
            if (newStatus != null) {
                if (debugEnabled) {
                    log.debug("new status = {}", newStatus);
                }
                this.serverJob.setSubmissionStatus(newStatus);
            }
        };
        r.run();
    }
}

