/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.protocol;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import org.jppf.io.DataLocation;
import org.jppf.job.JobInformation;
import org.jppf.management.JPPFManagementInfo;
import org.jppf.node.protocol.BundleParameter;
import org.jppf.node.protocol.JobMetadata;
import org.jppf.node.protocol.JobSLA;
import org.jppf.node.protocol.TaskBundle;
import org.jppf.node.protocol.TaskState;
import org.jppf.node.protocol.graph.TaskGraph;
import org.jppf.server.JPPFDriver;
import org.jppf.server.job.JPPFJobManager;
import org.jppf.server.job.management.NodeJobInformation;
import org.jppf.server.protocol.AbstractServerJobBase;
import org.jppf.server.protocol.ServerJobChangeListener;
import org.jppf.server.protocol.ServerJobStatus;
import org.jppf.server.protocol.ServerTask;
import org.jppf.server.protocol.ServerTaskBundleClient;
import org.jppf.server.protocol.ServerTaskBundleNode;
import org.jppf.server.submission.SubmissionStatus;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.collections.CollectionMap;
import org.jppf.utils.collections.SetIdentityMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerJob
extends AbstractServerJobBase {
    private static final Logger log = LoggerFactory.getLogger(ServerJob.class);
    private static final boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    private static final boolean traceEnabled = log.isTraceEnabled();
    private final TaskGraph taskGraph;
    private final Set<Integer> dispatchedTasks = new HashSet<Integer>();

    public ServerJob(Lock lock, ServerJobChangeListener notificationEmitter, TaskBundle job, DataLocation dataProvider) {
        super(lock, notificationEmitter, job, dataProvider);
        this.taskGraph = (TaskGraph)job.removeParameter((Object)BundleParameter.JOB_TASK_GRAPH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerTaskBundleNode createNodeDispatch(int nbTasks) {
        this.lock.lock();
        try {
            ServerTaskBundleNode serverTaskBundleNode;
            block21: {
                ArrayList<Object> list = null;
                try {
                    TaskBundle newTaskBundle;
                    if (this.taskGraph == null) {
                        if (nbTasks >= this.tasks.size() || this.taskGraph != null) {
                            list = new ArrayList(this.tasks.values());
                        } else {
                            list = new ArrayList(nbTasks);
                            Iterator it = this.tasks.entrySet().iterator();
                            for (int i = 0; i < nbTasks; ++i) {
                                Map.Entry entry = it.next();
                                list.add(entry.getValue());
                            }
                        }
                        if (debugEnabled) {
                            log.debug("requested tasks={}, found tasks={}", (Object)nbTasks, (Object)list.size());
                        }
                    } else {
                        Set availablePos = this.taskGraph.getAvailableNodes();
                        int effectiveNbTasks = Math.min(nbTasks, availablePos.size());
                        Iterator it = availablePos.iterator();
                        list = new ArrayList(effectiveNbTasks);
                        int count = 0;
                        while (it.hasNext() && count < nbTasks) {
                            int n = (Integer)it.next();
                            if (this.dispatchedTasks.contains(n)) continue;
                            this.dispatchedTasks.add(n);
                            ++count;
                            list.add(this.tasks.get(n));
                        }
                        if (debugEnabled) {
                            log.debug("count={}, nbTasks={}, effectiveNbTasks={}, dispatchedTasks={} for {}", new Object[]{count, nbTasks, effectiveNbTasks, this.dispatchedTasks.size(), this});
                        }
                    }
                    if (list.isEmpty() && !this.getJob().isHandshake()) {
                        throw new IllegalStateException("list of tasks to dispatch is empty");
                    }
                    int taskCount = list.size();
                    if (this.job.getCurrentTaskCount() > taskCount) {
                        int newSize = this.job.getCurrentTaskCount() - taskCount;
                        newTaskBundle = this.job.copy();
                        newTaskBundle.removeParameter((Object)BundleParameter.JOB_TASK_GRAPH);
                        newTaskBundle.setTaskCount(taskCount);
                        newTaskBundle.setCurrentTaskCount(taskCount);
                        this.job.setCurrentTaskCount(newSize);
                    } else {
                        newTaskBundle = this.job.copy();
                        this.job.setCurrentTaskCount(0);
                    }
                    if (!this.job.isHandshake() && this.getSLA().getDependencySpec().getId() != null) {
                        newTaskBundle.setParameter((Object)BundleParameter.JOB_GRAPH_ALREADY_HANDLED, (Object)true);
                    }
                    serverTaskBundleNode = new ServerTaskBundleNode(this, newTaskBundle, list);
                    if (list == null) break block21;
                }
                catch (Throwable throwable) {
                    if (list != null) {
                        for (ServerTask serverTask : list) {
                            this.tasks.remove(serverTask.getPosition());
                            if (this.taskGraph == null || !this.taskGraph.isDependendOn(serverTask.getPosition())) continue;
                            this.dependendedOnTasks.put(serverTask.getPosition(), serverTask);
                        }
                    }
                    this.fireJobUpdated(false);
                    throw throwable;
                }
                for (ServerTask serverTask : list) {
                    this.tasks.remove(serverTask.getPosition());
                    if (this.taskGraph == null || !this.taskGraph.isDependendOn(serverTask.getPosition())) continue;
                    this.dependendedOnTasks.put(serverTask.getPosition(), serverTask);
                }
            }
            this.fireJobUpdated(false);
            return serverTaskBundleNode;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resultsReceived(ServerTaskBundleNode bundle, List<DataLocation> results) {
        if (debugEnabled) {
            log.debug("received {} results from {}", results == null ? "null" : Integer.valueOf(results.size()), (Object)bundle);
        }
        if (results != null && results.isEmpty()) {
            return;
        }
        SetIdentityMap map = new SetIdentityMap();
        this.lock.lock();
        try {
            boolean b;
            List<Object> bundleTasks = bundle == null ? new ArrayList(this.tasks.values()) : bundle.getTaskList();
            boolean bl = b = this.isJobExpired() || this.isCancelled() || bundle.isExpired() && bundle.isOffline();
            if (b) {
                for (ServerTask serverTask : bundleTasks) {
                    map.putValue((Object)serverTask.getBundle(), (Object)serverTask);
                }
            } else if (results != null) {
                int n;
                int nbResubmits = 0;
                boolean bl2 = false;
                int minPos = Integer.MAX_VALUE;
                for (int i = 0; i < bundleTasks.size(); ++i) {
                    ServerTask task = (ServerTask)bundleTasks.get(i);
                    int pos = task.getPosition();
                    if (task.getState() == TaskState.RESUBMIT) {
                        if (traceEnabled) {
                            log.trace("task to resubmit: {}", (Object)task);
                        }
                        task.setState(TaskState.PENDING);
                        task.setReturnedFromNode(false);
                        ++nbResubmits;
                        if (pos > n) {
                            n = pos;
                        }
                        if (pos >= minPos) continue;
                        minPos = pos;
                        continue;
                    }
                    if (this.taskGraph != null) {
                        this.dispatchedTasks.remove(pos);
                        this.taskGraph.nodeDone(pos);
                    }
                    DataLocation location = results.get(i);
                    task.resultReceived(location);
                    map.putValue((Object)task.getBundle(), (Object)task);
                }
                if (debugEnabled && nbResubmits > 0) {
                    log.debug("got {} tasks to resubmit with minPos={}, maxPos={} for {}", new Object[]{nbResubmits, minPos, n, this});
                }
            } else if (debugEnabled) {
                log.debug("results are null, job is neither expired nor cancelled, node bundle not expired: {}", (Object)bundle);
            }
        }
        finally {
            this.lock.unlock();
        }
        if (debugEnabled && this.taskGraph != null) {
            log.debug("taskGraph = {}, sentTasks = {}", (Object)this.taskGraph, this.dispatchedTasks);
        }
        this.postResultsReceived((CollectionMap<ServerTaskBundleClient, ServerTask>)map, bundle, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resultsReceived(ServerTaskBundleNode bundle, Throwable throwable) {
        if (bundle == null) {
            throw new IllegalArgumentException("bundle is null");
        }
        if (debugEnabled) {
            log.debug("*** received exception '{}' from {}", (Object)ExceptionUtils.getMessage((Throwable)throwable), (Object)bundle);
        }
        SetIdentityMap map = new SetIdentityMap();
        this.lock.lock();
        try {
            int nbResubmits = 0;
            int maxPos = 0;
            int minPos = Integer.MAX_VALUE;
            for (ServerTask task : bundle.getTaskList()) {
                int pos = task.getPosition();
                if (task.getState() == TaskState.RESUBMIT) {
                    if (traceEnabled) {
                        log.trace("task to resubmit: {}", (Object)task);
                    }
                    task.setState(TaskState.PENDING);
                    task.setReturnedFromNode(false);
                    ++nbResubmits;
                    if (pos > maxPos) {
                        maxPos = pos;
                    }
                    if (pos >= minPos) continue;
                    minPos = pos;
                    continue;
                }
                if (this.taskGraph != null) {
                    this.dispatchedTasks.remove(pos);
                    this.taskGraph.nodeDone(pos);
                }
                task.resultReceived(throwable);
                if (this.taskGraph != null) {
                    this.taskGraph.nodeDone(pos);
                }
                map.putValue((Object)task.getBundle(), (Object)task);
            }
            if (debugEnabled && nbResubmits > 0) {
                log.debug("got {} tasks to resubmit with minPos={}, maxPos={} for {}", new Object[]{nbResubmits, minPos, maxPos, this});
            }
        }
        finally {
            this.lock.unlock();
        }
        if (debugEnabled && this.taskGraph != null) {
            log.debug("taskGraph = {}, sentTasks = {}", (Object)this.taskGraph, this.dispatchedTasks);
        }
        this.postResultsReceived((CollectionMap<ServerTaskBundleClient, ServerTask>)map, bundle, throwable);
    }

    private void postResultsReceived(CollectionMap<ServerTaskBundleClient, ServerTask> map, ServerTaskBundleNode bundle, Throwable throwable) {
        if (debugEnabled) {
            log.debug("client bundle map has {} keys: {}", (Object)map.keySet().size(), (Object)map.keySet());
        }
        map.forEach((clientBundle, tasks) -> {
            if (throwable == null) {
                clientBundle.resultReceived((Collection<ServerTask>)tasks);
            } else {
                clientBundle.resultReceived((Collection<ServerTask>)tasks, throwable);
            }
            ((JPPFJobManager)this.notificationEmitter).jobResultsReceived(bundle.getChannel(), this, (Collection<ServerTask>)tasks);
            if (debugEnabled) {
                log.debug("received results for {}", clientBundle);
            }
        });
        this.taskCompleted(bundle, throwable);
        if (((Boolean)this.getJob().getParameter((Object)BundleParameter.FROM_PERSISTENCE, (Object)false)).booleanValue() || this.submissionStatus.get() == SubmissionStatus.COMPLETE) {
            map.forEach((clientBundle, tasks) -> {
                if (debugEnabled) {
                    log.debug("checking bundleEnded() for {}", clientBundle);
                }
                if (clientBundle.getPendingTasksCount() <= 0) {
                    clientBundle.bundleEnded();
                }
            });
        }
    }

    private static void addAll(List<DataLocation> dst, Collection<ServerTask> src) {
        for (ServerTask item : src) {
            dst.add(item.getInitialTask());
        }
    }

    private static void addExcluded(List<DataLocation> dst, List<ServerTask> src, TaskState state) {
        for (ServerTask item : src) {
            if (item.getState() == state) continue;
            dst.add(item.getInitialTask());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void taskCompleted(ServerTaskBundleNode bundle, Throwable throwable) {
        boolean requeue = false;
        ArrayList<DataLocation> list = new ArrayList<DataLocation>();
        this.lock.lock();
        try {
            if (this.getSLA().isBroadcastJob()) {
                if (debugEnabled) {
                    log.debug("processing broadcast job");
                }
                if (bundle != null) {
                    ServerJob.addExcluded(list, bundle.getTaskList(), TaskState.RESULT);
                }
                if (this.isCancelled() || this.getBroadcastUUID() == null) {
                    ServerJob.addAll(list, this.tasks.values());
                }
            } else if (bundle != null) {
                if (debugEnabled) {
                    log.debug("processing pending tasks");
                }
                ArrayList<ServerTask> taskList = new ArrayList<ServerTask>();
                for (ServerTask task : bundle.getTaskList()) {
                    if (task.getState() == TaskState.RESUBMIT) {
                        task.setState(TaskState.PENDING);
                    }
                    if (task.getState() != TaskState.PENDING) continue;
                    taskList.add(task);
                }
                requeue = this.merge(taskList, false);
            }
        }
        finally {
            this.lock.unlock();
        }
        if (debugEnabled) {
            log.debug("requeue = {} for bundle {}, job = {}", new Object[]{requeue, bundle, this});
        }
        if (this.hasPending()) {
            if (debugEnabled) {
                log.debug("processing hasPending=true");
            }
            if (throwable != null && !requeue) {
                this.setSubmissionStatus(SubmissionStatus.FAILED);
            }
            if (!this.isCancelled() && requeue && this.onRequeue != null) {
                this.onRequeue.run();
            }
        } else {
            if (debugEnabled) {
                log.debug("processing hasPending=false");
            }
            this.setSubmissionStatus(SubmissionStatus.COMPLETE);
            this.updateStatus(ServerJobStatus.EXECUTING, ServerJobStatus.DONE);
        }
        if (this.clientBundles.isEmpty() && this.tasks.isEmpty()) {
            this.setSubmissionStatus(SubmissionStatus.ENDED);
        }
        if (debugEnabled) {
            log.debug("submissionStatus={}, clientBundles={} for {}", new Object[]{this.getSubmissionStatus(), this.clientBundles.size(), this});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCancelledStatus() {
        HashMap<Long, ServerTaskBundleNode> map;
        Map map2 = this.dispatchSet;
        synchronized (map2) {
            map = new HashMap<Long, ServerTaskBundleNode>(this.dispatchSet);
        }
        if (debugEnabled) {
            log.debug("cancelling {} dispatches for {}", (Object)map.size(), (Object)this);
        }
        map.forEach((id, nodeBundle) -> this.cancelDispatch((ServerTaskBundleNode)nodeBundle));
    }

    public void cancelDispatch(ServerTaskBundleNode nodeBundle) {
        try {
            Future<?> future = nodeBundle.getFuture();
            if (future != null && !future.isDone()) {
                future.cancel(false);
            }
            nodeBundle.resultsReceived((List<DataLocation>)null);
        }
        catch (Exception e) {
            log.error("Error cancelling job " + this, (Throwable)e);
        }
    }

    private CollectionMap<ServerTaskBundleClient, ServerTask> handleCancelledTasks() {
        if (debugEnabled) {
            log.debug("cancelling tasks for {}", (Object)this);
        }
        SetIdentityMap clientMap = new SetIdentityMap();
        for (ServerTask task : this.tasks.values()) {
            if (task.isDone() || task.isReturnedFromNode()) continue;
            task.cancel();
            clientMap.putValue((Object)task.getBundle(), (Object)task);
        }
        return clientMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel(JPPFDriver driver, boolean mayInterruptIfRunning) {
        if (debugEnabled) {
            log.debug("request to cancel {}", (Object)this);
        }
        boolean result = false;
        CollectionMap<ServerTaskBundleClient, ServerTask> clientMap = null;
        this.lock.lock();
        try {
            if (this.setCancelled(mayInterruptIfRunning)) {
                driver.getQueue().getDependenciesHandler().jobCancelled(this);
                this.handleCancelledStatus();
                if (!this.getSLA().isBroadcastJob()) {
                    clientMap = this.handleCancelledTasks();
                }
                this.setSubmissionStatus(SubmissionStatus.COMPLETE);
                driver.getAsyncNodeNioServer().getNodeReservationHandler().onJobCancelled(this);
                result = true;
            }
        }
        finally {
            this.lock.unlock();
        }
        if (clientMap != null) {
            clientMap.forEach((clientBundle, tasks) -> clientBundle.resultReceived((Collection<ServerTask>)tasks));
        }
        if (result) {
            this.setSubmissionStatus(SubmissionStatus.ENDED);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeJobInformation[] getNodeJobInformation() {
        ServerTaskBundleNode[] entries;
        Map map = this.dispatchSet;
        synchronized (map) {
            if (this.dispatchSet.isEmpty()) {
                return NodeJobInformation.EMPTY_ARRAY;
            }
            entries = this.dispatchSet.values().toArray(new ServerTaskBundleNode[this.dispatchSet.size()]);
        }
        NodeJobInformation[] result = new NodeJobInformation[entries.length];
        int i = 0;
        for (ServerTaskBundleNode nodeBundle : entries) {
            JPPFManagementInfo nodeInfo = nodeBundle.getChannel().getManagementInfo();
            TaskBundle bundle = nodeBundle.getJob();
            JobInformation jobInfo = new JobInformation(bundle);
            jobInfo.setMaxNodes(bundle.getSLA().getMaxNodes());
            result[i++] = new NodeJobInformation(nodeInfo, jobInfo);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(JPPFDriver driver, JobSLA sla, JobMetadata metadata) {
        if (debugEnabled) {
            log.debug("request to update {}", (Object)this);
        }
        boolean updated = false;
        this.lock.lock();
        try {
            if (sla != null) {
                this.job.setSLA(sla);
                driver.getQueue().updateSchedules(this);
                updated = true;
            }
            if (metadata != null) {
                this.job.setMetadata(metadata);
                updated = true;
            }
        }
        finally {
            this.lock.unlock();
        }
        if (updated) {
            this.fireJobUpdated(true);
        }
    }

    public TaskGraph getTaskGraph() {
        return this.taskGraph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAvailableGraphNode() {
        Map map = this.tasks;
        synchronized (map) {
            if (this.taskGraph == null) {
                return false;
            }
            return this.taskGraph.getAvailableNodes().size() - this.dispatchedTasks.size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAvailableGraphNodeCount() {
        Map map = this.tasks;
        synchronized (map) {
            return this.taskGraph != null ? this.taskGraph.getAvailableNodes().size() - this.dispatchedTasks.size() : -1;
        }
    }
}

