/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.protocol;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.jppf.io.DataLocation;
import org.jppf.node.protocol.JobSLA;
import org.jppf.node.protocol.TaskBundle;
import org.jppf.server.JPPFDriver;
import org.jppf.server.protocol.ServerJob;
import org.jppf.server.protocol.ServerJobChangeListener;
import org.jppf.server.protocol.ServerJobStatus;
import org.jppf.server.protocol.ServerTask;
import org.jppf.server.protocol.ServerTaskBundleClient;
import org.jppf.server.protocol.ServerTaskBundleNode;
import org.jppf.server.submission.SubmissionStatus;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.collections.SetIdentityMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerJobBroadcast
extends ServerJob {
    private static final Logger log = LoggerFactory.getLogger(ServerJobBroadcast.class);
    private static boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    private transient ServerJobBroadcast parentJob;
    private transient String broadcastUUID;
    private final Map<String, ServerJobBroadcast> broadcastMap;
    private final Set<ServerJobBroadcast> broadcastSet = new LinkedHashSet<ServerJobBroadcast>();
    protected int pendingTasksCount;
    private JobSLA sla;

    public ServerJobBroadcast(Lock lock, ServerJobChangeListener notificationEmitter, TaskBundle job, DataLocation dataProvider) {
        this(lock, notificationEmitter, job, dataProvider, null, null);
    }

    protected ServerJobBroadcast(Lock lock, ServerJobChangeListener notificationEmitter, TaskBundle job, DataLocation dataProvider, ServerJobBroadcast parentJob, String broadcastUUID) {
        super(lock, notificationEmitter, job, dataProvider);
        if (!job.getSLA().isBroadcastJob()) {
            throw new IllegalStateException("Not broadcast job");
        }
        this.parentJob = parentJob;
        this.broadcastUUID = broadcastUUID;
        this.broadcastMap = broadcastUUID == null ? new LinkedHashMap<String, ServerJobBroadcast>() : Collections.emptyMap();
        this.sla = job.getSLA();
    }

    @Override
    public String getBroadcastUUID() {
        return this.broadcastUUID;
    }

    public ServerJobBroadcast createBroadcastJob(String broadcastUUID) {
        ServerJobBroadcast broadcastJob;
        if (broadcastUUID == null || broadcastUUID.isEmpty()) {
            throw new IllegalArgumentException("broadcastUUID is blank");
        }
        this.lock.lock();
        try {
            broadcastJob = new ServerJobBroadcast(this.lock, this.notificationEmitter, this.job, this.getDataProvider(), this, broadcastUUID);
            broadcastJob.tasks.putAll(this.tasks);
            broadcastJob.pendingTasksCount = this.tasks.size();
            this.broadcastSet.add(broadcastJob);
        }
        finally {
            this.lock.unlock();
        }
        return broadcastJob;
    }

    @Override
    public void jobDispatched(ServerTaskBundleNode bundle) {
        super.jobDispatched(bundle);
        if (this.parentJob != null) {
            this.parentJob.broadcastDispatched(this);
        }
    }

    protected void broadcastDispatched(ServerJobBroadcast broadcastJob) {
        if (broadcastJob == null) {
            throw new IllegalArgumentException("broadcastJob is null");
        }
        if (debugEnabled) {
            log.debug("dispatched broadcast {}", (Object)broadcastJob);
        }
        this.lock.lock();
        try {
            this.broadcastSet.remove(broadcastJob);
            boolean empty = this.broadcastMap.isEmpty();
            this.broadcastMap.put(broadcastJob.getBroadcastUUID(), broadcastJob);
            if (empty) {
                this.updateStatus(ServerJobStatus.NEW, ServerJobStatus.EXECUTING);
                this.setSubmissionStatus(SubmissionStatus.EXECUTING);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void broadcastCompleted(ServerJobBroadcast broadcastJob) {
        if (broadcastJob == null) {
            throw new IllegalArgumentException("broadcastJob is null");
        }
        if (debugEnabled) {
            log.debug("received broadcast results {}", (Object)broadcastJob);
        }
        this.lock.lock();
        try {
            if (this.broadcastMap.remove(broadcastJob.getBroadcastUUID()) != broadcastJob && !this.broadcastSet.contains(broadcastJob)) {
                throw new IllegalStateException("broadcast job not found");
            }
            if (this.broadcastMap.isEmpty()) {
                this.jobEnded();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void jobEnded() {
        if (debugEnabled) {
            log.debug("broadcast job ended {}", (Object)this);
        }
        this.setSubmissionStatus(SubmissionStatus.ENDED);
        SetIdentityMap clientMap = new SetIdentityMap();
        for (ServerTask task : this.tasks.values()) {
            if (task.isDone()) continue;
            task.broadcastResultReceived();
            clientMap.putValue((Object)task.getBundle(), (Object)task);
        }
        for (Map.Entry entry : clientMap.entrySet()) {
            ((ServerTaskBundleClient)entry.getKey()).resultReceived((Collection)entry.getValue());
        }
        this.tasks.clear();
    }

    @Override
    public void resultsReceived(ServerTaskBundleNode bundle, List<DataLocation> results) {
        if (debugEnabled) {
            log.debug("received results for {}", (Object)this);
        }
        this.pendingTasksCount -= bundle.getTaskCount();
        this.taskCompleted(bundle, null);
        if (this.pendingTasksCount <= 0) {
            this.parentJob.broadcastCompleted(this);
        }
    }

    @Override
    public void resultsReceived(ServerTaskBundleNode bundle, Throwable throwable) {
        this.pendingTasksCount -= bundle.getTaskCount();
        this.taskCompleted(bundle, throwable);
        if (this.pendingTasksCount <= 0) {
            this.parentJob.broadcastCompleted(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addBundle(ServerTaskBundleClient clientBundle) {
        this.lock.lock();
        try {
            if (this.parentJob == null) {
                boolean b = super.addBundle(clientBundle);
                ArrayList<ServerJobBroadcast> list = new ArrayList<ServerJobBroadcast>(this.broadcastSet.size() + this.broadcastMap.size());
                list.addAll(this.broadcastMap.values());
                list.addAll(this.broadcastSet);
                for (ServerJobBroadcast broadcastJob : list) {
                    this.addBundle(broadcastJob, clientBundle);
                }
                boolean bl = b;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void addBundle(ServerJobBroadcast broadcastJob, ServerTaskBundleClient bundle) {
        if (broadcastJob.getSubmissionStatus() == SubmissionStatus.COMPLETE) {
            if (broadcastJob.completionBundles == null) {
                broadcastJob.completionBundles = new ArrayList();
            }
            broadcastJob.completionBundles.add(bundle);
        } else {
            if (broadcastJob.getSubmissionStatus() == SubmissionStatus.ENDED) {
                throw new IllegalStateException("Job ENDED");
            }
            broadcastJob.clientBundles.add(bundle);
            for (ServerTask task : bundle.getTaskList()) {
                broadcastJob.tasks.put(task.getPosition(), task);
            }
            this.fireJobUpdated(false);
            broadcastJob.pendingTasksCount += bundle.getTaskCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(JPPFDriver driver, boolean mayInterruptIfRunning) {
        if (debugEnabled) {
            log.debug("request to cancel " + this);
        }
        this.lock.lock();
        try {
            if (this.parentJob == null) {
                if (!this.setCancelled(mayInterruptIfRunning)) {
                    boolean bl = false;
                    return bl;
                }
                ArrayList<ServerJobBroadcast> list = new ArrayList<ServerJobBroadcast>(this.broadcastSet.size() + this.broadcastMap.size());
                list.addAll(this.broadcastMap.values());
                list.addAll(this.broadcastSet);
                this.broadcastSet.clear();
                for (ServerJobBroadcast broadcastJob : list) {
                    broadcastJob.cancel(driver, false);
                }
                this.jobEnded();
                boolean bl = true;
                return bl;
            }
            boolean bl = super.cancel(driver, mayInterruptIfRunning);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public ServerJobBroadcast getParentJob() {
        return this.parentJob;
    }

    public List<ServerJobBroadcast> getDispatchedBroadcasts() {
        this.lock.lock();
        try {
            ArrayList<ServerJobBroadcast> arrayList = this.parentJob != null ? Collections.emptyList() : new ArrayList<ServerJobBroadcast>(this.broadcastMap.values());
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public JobSLA getSLA() {
        return this.sla;
    }

    @Override
    public void setSLA(JobSLA sla) {
        this.sla = sla;
    }
}

