/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.protocol;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.jppf.io.DataLocation;
import org.jppf.io.IOHelper;
import org.jppf.io.InputSource;
import org.jppf.io.MultipleBuffersLocation;
import org.jppf.io.OutputDestination;
import org.jppf.io.StreamInputSource;
import org.jppf.io.StreamOutputDestination;
import org.jppf.node.protocol.PositionalElement;
import org.jppf.node.protocol.TaskState;
import org.jppf.server.protocol.ServerTaskBundleClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerTask
implements Serializable,
PositionalElement<ServerTask> {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(ServerTask.class);
    private static final boolean traceEnabled = log.isTraceEnabled();
    private transient ServerTaskBundleClient bundle;
    private int jobPosition;
    private DataLocation initialTask;
    private transient DataLocation result;
    private Throwable throwable;
    private TaskState state = TaskState.PENDING;
    private int expirationCount;
    private int maxResubmits;
    private int resubmitCount;
    private boolean returnedFromNode;

    public ServerTask(ServerTaskBundleClient bundle, DataLocation initialTask, int jobPosition, int maxResubmits) {
        if (bundle == null) {
            throw new IllegalArgumentException("bundle is null");
        }
        this.bundle = bundle;
        this.initialTask = initialTask == null ? new MultipleBuffersLocation(0) : initialTask;
        this.jobPosition = jobPosition;
        this.maxResubmits = maxResubmits;
    }

    public ServerTaskBundleClient getBundle() {
        return this.bundle;
    }

    public void setBundle(ServerTaskBundleClient bundle) {
        this.bundle = bundle;
    }

    public DataLocation getInitialTask() {
        return this.initialTask;
    }

    public TaskState getState() {
        return this.state;
    }

    public void setState(TaskState state) {
        this.state = state;
    }

    public DataLocation getResult() {
        return this.result == null ? this.initialTask : this.result;
    }

    public void setResult(DataLocation result) {
        this.result = result;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public void cancel() {
        if (traceEnabled) {
            log.trace("cancelling {}", (Object)this);
        }
        this.result = this.initialTask;
        this.state = TaskState.CANCELLED;
    }

    public void resubmit() {
        if (traceEnabled) {
            log.trace("resubmitting {}", (Object)this);
        }
        this.result = null;
        this.state = TaskState.RESUBMIT;
    }

    public void resultReceived(DataLocation result) {
        if (result == null) {
            throw new IllegalArgumentException("result is null");
        }
        this.result = result;
        this.throwable = null;
        TaskState taskState = this.state = result == this.initialTask ? TaskState.CANCELLED : TaskState.RESULT;
        if (traceEnabled) {
            log.trace("result received for {}", (Object)this);
        }
    }

    public void broadcastResultReceived() {
        this.result = this.initialTask;
        this.state = TaskState.RESULT;
    }

    public void resultReceived(Throwable exception) {
        if (exception == null) {
            throw new IllegalArgumentException("exception is null");
        }
        this.result = null;
        this.throwable = exception;
        this.state = TaskState.EXCEPTION;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + "state=" + this.getState() + ", jobPosition=" + this.jobPosition + ", expirationCount=" + this.expirationCount + ", dataLocation=" + this.initialTask + ", result=" + this.result + ", exception=" + this.throwable + ']';
    }

    public int getPosition() {
        return this.jobPosition;
    }

    public int incExpirationCount() {
        return ++this.expirationCount;
    }

    public int getExpirationCount() {
        return this.expirationCount;
    }

    public boolean isDone() {
        return this.state.ordinal() >= TaskState.EXCEPTION.ordinal();
    }

    public int getTaskResubmitCount() {
        return this.resubmitCount;
    }

    public int incResubmitCount() {
        return ++this.resubmitCount;
    }

    public int getMaxResubmits() {
        return this.maxResubmits;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.jobPosition);
        out.writeInt(this.expirationCount);
        out.writeInt(this.maxResubmits);
        out.writeInt(this.resubmitCount);
        out.writeObject(this.state);
        out.writeObject(this.throwable);
        try {
            IOHelper.writeData((DataLocation)this.initialTask, (OutputDestination)new StreamOutputDestination((OutputStream)out));
        }
        catch (Exception e) {
            throw e instanceof IOException ? (IOException)e : new IOException(e);
        }
    }

    public boolean isReturnedFromNode() {
        return this.returnedFromNode;
    }

    public void setReturnedFromNode(boolean returnedFromNode) {
        this.returnedFromNode = returnedFromNode;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.jobPosition = in.readInt();
        this.expirationCount = in.readInt();
        this.maxResubmits = in.readInt();
        this.resubmitCount = in.readInt();
        this.state = (TaskState)in.readObject();
        this.throwable = (Throwable)in.readObject();
        try {
            this.initialTask = IOHelper.readData((InputSource)new StreamInputSource((InputStream)in));
        }
        catch (IOException | ClassNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

