/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.protocol;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jppf.io.DataLocation;
import org.jppf.node.protocol.BundleParameter;
import org.jppf.node.protocol.JobSLA;
import org.jppf.node.protocol.TaskBundle;
import org.jppf.node.protocol.TaskState;
import org.jppf.node.protocol.graph.TaskGraphInfo;
import org.jppf.server.protocol.SendResultsStrategy;
import org.jppf.server.protocol.SendResultsStrategyManager;
import org.jppf.server.protocol.ServerTask;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerTaskBundleClient {
    private static final Logger log = LoggerFactory.getLogger(ServerTaskBundleClient.class);
    private static final boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    private static final AtomicLong INSTANCE_COUNT = new AtomicLong(0L);
    private final long id;
    private final TaskBundle job;
    private final DataLocation dataProvider;
    private final List<ServerTask> taskList = new LinkedList<ServerTask>();
    private final List<ServerTask> tasksToSendList = new LinkedList<ServerTask>();
    private final List<ServerTask> nullTasks = new LinkedList<ServerTask>();
    private final AtomicInteger pendingTasksCount = new AtomicInteger();
    private final List<CompletionListener> listenerList = new CopyOnWriteArrayList<CompletionListener>();
    private boolean cancelled;
    private boolean done;
    private long jobReceivedTime;
    final SendResultsStrategy strategy;
    final long sourceBundleId;
    private final int[] tasksPositions;
    private TaskGraphInfo graphInfo;
    private final AtomicBoolean isEnded = new AtomicBoolean(false);

    public ServerTaskBundleClient(TaskBundle job, DataLocation dataProvider, List<DataLocation> taskList, boolean forPeer) {
        if (job == null) {
            throw new IllegalArgumentException("job is null");
        }
        if (taskList == null) {
            throw new IllegalArgumentException("taskList is null");
        }
        this.id = INSTANCE_COUNT.incrementAndGet();
        this.job = job;
        this.dataProvider = dataProvider;
        this.sourceBundleId = -1L;
        if (!job.isHandshake() && !((Boolean)job.getParameter((Object)BundleParameter.CLOSE_COMMAND, (Object)false)).booleanValue()) {
            int[] positions = (int[])job.getParameter((Object)BundleParameter.TASK_POSITIONS);
            int[] maxResubmits = (int[])job.getParameter((Object)BundleParameter.TASK_MAX_RESUBMITS);
            int slaMaxResubmits = job.getSLA().getMaxTaskResubmits();
            if (log.isTraceEnabled()) {
                log.trace("id={}, nbTasks={}, nbPositions={} : {}", new Object[]{this.id, taskList.size(), positions == null ? -1 : positions.length, positions == null ? "null" : Arrays.toString(positions)});
            }
            for (int i = 0; i < taskList.size(); ++i) {
                int maxResubmitCount;
                DataLocation dataLocation = taskList.get(i);
                if (positions == null && !job.isHandshake()) {
                    throw new IllegalStateException("positions is null for " + this);
                }
                if (positions != null && i >= positions.length) {
                    throw new IllegalStateException(i + " >= " + positions.length + " for " + this);
                }
                int pos = positions == null || i >= positions.length ? -1 : positions[i];
                int n = maxResubmitCount = maxResubmits == null || i > maxResubmits.length - 1 ? -1 : maxResubmits[i];
                if (maxResubmitCount < 0 && slaMaxResubmits >= 0) {
                    maxResubmitCount = slaMaxResubmits;
                }
                ServerTask task = new ServerTask(this, dataLocation, pos, maxResubmitCount);
                if (dataLocation == null) {
                    if (debugEnabled) {
                        log.debug("got null task at index {} for {}", (Object)i, (Object)job);
                    }
                    this.nullTasks.add(task);
                    task.resultReceived(task.getInitialTask());
                    continue;
                }
                this.taskList.add(task);
            }
            this.pendingTasksCount.set(this.taskList.size() + this.nullTasks.size());
            this.strategy = forPeer ? new SendResultsStrategy.SendAllResultsStrategy() : SendResultsStrategyManager.getStrategy(job.getSLA().getResultsStrategy());
        } else {
            this.strategy = SendResultsStrategyManager.getStrategy(null);
        }
        this.tasksPositions = this.computeTasksPositions();
    }

    public ServerTaskBundleClient(Collection<ServerTask> tasks, TaskBundle job, DataLocation dataProvider) {
        if (job == null) {
            throw new IllegalArgumentException("job is null");
        }
        if (this.taskList == null) {
            throw new IllegalArgumentException("taskList is null");
        }
        this.id = INSTANCE_COUNT.incrementAndGet();
        this.job = job;
        this.dataProvider = dataProvider;
        this.taskList.addAll(tasks);
        for (ServerTask task : tasks) {
            task.setBundle(this);
        }
        this.pendingTasksCount.set(tasks.size());
        this.strategy = SendResultsStrategyManager.getStrategy(job.getSLA().getResultsStrategy());
        this.sourceBundleId = -1L;
        this.tasksPositions = this.computeTasksPositions();
    }

    private ServerTaskBundleClient(ServerTaskBundleClient source, List<ServerTask> taskList) {
        if (source == null) {
            throw new IllegalArgumentException("source is null");
        }
        if (taskList == null) {
            throw new IllegalArgumentException("taskList is null");
        }
        this.id = INSTANCE_COUNT.incrementAndGet();
        int size = taskList.size();
        this.job = source.getJob().copy();
        this.job.removeParameter((Object)BundleParameter.JOB_TASK_GRAPH);
        this.job.setTaskCount(size);
        this.job.setInitialTaskCount(source.getJob().getInitialTaskCount());
        this.job.setCurrentTaskCount(size);
        this.dataProvider = source.getDataProvider();
        this.taskList.addAll(taskList);
        this.pendingTasksCount.set(0);
        this.done = source.isDone();
        this.cancelled = source.isCancelled();
        this.strategy = source.strategy;
        this.sourceBundleId = source.getId();
        this.tasksPositions = this.computeTasksPositions();
    }

    private int[] computeTasksPositions() {
        int[] positions = new int[this.taskList.size()];
        int count = 0;
        for (ServerTask task : this.taskList) {
            positions[count++] = task.getPosition();
        }
        return positions;
    }

    public TaskBundle getJob() {
        return this.job;
    }

    public DataLocation getDataProvider() {
        return this.dataProvider;
    }

    public List<ServerTask> getTaskList() {
        return this.taskList;
    }

    public void handleNullTasks() {
        if (!this.nullTasks.isEmpty()) {
            if (debugEnabled) {
                log.debug("received {} null tasks", (Object)this.nullTasks.size());
            }
            this.resultReceived(this.nullTasks);
            this.nullTasks.clear();
        }
    }

    public synchronized void resultReceived(Collection<ServerTask> results) {
        boolean shouldFire;
        List<ServerTask> completedTasks = null;
        if (this.isCancelled()) {
            return;
        }
        if (debugEnabled) {
            log.debug("received {} tasks for {}", (Object)results.size(), (Object)this);
        }
        ArrayList<ServerTask> tasks = new ArrayList<ServerTask>(results.size());
        for (ServerTask task : results) {
            if (task.getState() == TaskState.PENDING) continue;
            tasks.add(task);
            this.tasksToSendList.add(task);
            this.pendingTasksCount.decrementAndGet();
        }
        this.done = this.pendingTasksCount.get() <= 0;
        boolean bl = shouldFire = this.done || this.strategy.sendResults(this, tasks);
        if (shouldFire) {
            completedTasks = this.getAndClearCompletedTasks();
        }
        if (debugEnabled) {
            log.debug("processed {} tasks, completedTasks={}, done={}, tasksToSend={}, pendingTasksCount={}", new Object[]{tasks.size(), completedTasks == null ? 0 : completedTasks.size(), this.done, this.tasksToSendList.size(), this.pendingTasksCount.get()});
        }
        if (completedTasks != null) {
            this.fireTasksCompleted(completedTasks);
        }
    }

    public synchronized void resultReceived(Collection<ServerTask> tasks, Throwable exception) {
        boolean shouldFire;
        List<ServerTask> completedTasks = null;
        if (this.isCancelled()) {
            return;
        }
        if (debugEnabled) {
            log.debug("received exception [{}] for {}", (Object)ExceptionUtils.getMessage((Throwable)exception), (Object)this);
        }
        int count = 0;
        for (ServerTask task : tasks) {
            if (task.getState() != TaskState.PENDING) {
                this.tasksToSendList.add(task);
                ++count;
            }
            if (count > 0) {
                this.pendingTasksCount.addAndGet(-count);
            }
            task.resultReceived(exception);
        }
        this.done = this.pendingTasksCount.get() <= 0;
        boolean bl = shouldFire = this.done || this.strategy.sendResults(this, tasks);
        if (shouldFire) {
            completedTasks = this.getAndClearCompletedTasks();
        }
        if (debugEnabled) {
            log.debug("processed {} tasks, completedTasks={}, done={}, tasksToSend={}", new Object[]{tasks.size(), completedTasks == null ? 0 : completedTasks.size(), this.done, this.tasksToSendList.size()});
        }
        if (completedTasks != null) {
            this.fireTasksCompleted(completedTasks);
        }
    }

    public long getJobReceivedTime() {
        return this.jobReceivedTime;
    }

    public void setJobReceivedTime(long jobReceivedTime) {
        this.jobReceivedTime = jobReceivedTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        List<ServerTask> completedTasks = null;
        ServerTaskBundleClient serverTaskBundleClient = this;
        synchronized (serverTaskBundleClient) {
            if (!this.cancelled && !this.done) {
                if (debugEnabled) {
                    log.debug("cancelling client job " + this);
                }
                this.cancelled = true;
                int count = 0;
                for (ServerTask task : this.taskList) {
                    if (task.getState() != TaskState.PENDING) continue;
                    task.cancel();
                    this.tasksToSendList.add(task);
                    ++count;
                }
                if (count > 0) {
                    this.pendingTasksCount.addAndGet(-count);
                }
                this.done = true;
                completedTasks = this.getAndClearCompletedTasks();
            }
        }
        this.fireTasksCompleted(completedTasks);
    }

    private synchronized List<ServerTask> getAndClearCompletedTasks() {
        ArrayList<ServerTask> completedTasks = new ArrayList<ServerTask>(this.tasksToSendList);
        this.tasksToSendList.clear();
        return completedTasks;
    }

    public synchronized boolean isCancelled() {
        return this.cancelled;
    }

    public synchronized boolean isDone() {
        return this.done;
    }

    public List<DataLocation> getDataLocationList() {
        ArrayList<DataLocation> list = new ArrayList<DataLocation>(this.taskList.size());
        for (ServerTask task : this.taskList) {
            list.add(task.getInitialTask());
        }
        return list;
    }

    public JobSLA getSLA() {
        return this.job.getSLA();
    }

    public String getUuid() {
        return this.job.getUuid();
    }

    public int getTaskCount() {
        return this.taskList.size();
    }

    public int getPendingTasksCount() {
        return this.pendingTasksCount.get();
    }

    private void fireTasksCompleted(List<ServerTask> completedTasks) {
        if (completedTasks != null) {
            ServerTaskBundleClient bundle = new ServerTaskBundleClient(this, completedTasks);
            if (debugEnabled) {
                log.debug("created bundle id=" + bundle.id + " for " + this);
            }
            for (CompletionListener listener : this.listenerList) {
                listener.taskCompleted(bundle, completedTasks);
            }
        }
    }

    public void bundleEnded() {
        if (debugEnabled) {
            log.debug("bundle ended {}", (Object)this);
        }
        if (this.isEnded.compareAndSet(false, true)) {
            for (CompletionListener listener : this.listenerList) {
                listener.bundleEnded(this);
            }
        }
    }

    public void addCompletionListener(CompletionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener is null");
        }
        if (debugEnabled) {
            log.debug("adding CompletionListener {} to {}", (Object)listener, (Object)this);
        }
        this.listenerList.add(listener);
    }

    public void removeCompletionListener(CompletionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener is null");
        }
        this.listenerList.remove(listener);
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + "id=" + this.id + ", pendingTasks=" + this.pendingTasksCount + ", tasks=" + this.taskList.size() + ", cancelled=" + this.cancelled + ", done=" + this.done + ", dependencies=" + (this.graphInfo == null ? 0 : this.graphInfo.getNbDependencies()) + ", job=" + this.job + "; strategy=" + (this.strategy == null ? "null" : this.strategy.getName()) + ']';
    }

    public long getId() {
        return this.id;
    }

    public long getOriginalBundleId() {
        return this.sourceBundleId < 0L ? this.id : this.sourceBundleId;
    }

    public int[] getTasksPositions() {
        return this.tasksPositions;
    }

    public TaskGraphInfo getTaskGraphInfo() {
        return this.graphInfo;
    }

    public void setDependencies(List<DataLocation> dependenciesLocations, TaskGraphInfo graphInfo) {
        this.graphInfo = graphInfo;
        ArrayList<ServerTask> deps = new ArrayList<ServerTask>(dependenciesLocations.size());
        int[] positions = graphInfo.getDependenciesPositions();
        for (int i = 0; i < positions.length; ++i) {
            DataLocation location = dependenciesLocations.get(i);
            ServerTask task = new ServerTask(this, location, positions[i], 0);
            task.setResult(location);
            task.setState(TaskState.RESULT);
            deps.add(task);
        }
        graphInfo.setDependencies(deps);
    }

    public static interface CompletionListener {
        public void taskCompleted(ServerTaskBundleClient var1, List<ServerTask> var2);

        public void bundleEnded(ServerTaskBundleClient var1);
    }
}

