/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.protocol;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import org.jppf.execute.ExecutorChannel;
import org.jppf.io.DataLocation;
import org.jppf.job.JobReturnReason;
import org.jppf.node.protocol.TaskBundle;
import org.jppf.node.protocol.graph.TaskGraph;
import org.jppf.node.protocol.graph.TaskGraphInfo;
import org.jppf.server.protocol.ServerJob;
import org.jppf.server.protocol.ServerTask;
import org.jppf.server.protocol.ServerTaskBundleClient;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.collections.ArrayListHashMap;
import org.jppf.utils.collections.CollectionMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerTaskBundleNode {
    private static final Logger log = LoggerFactory.getLogger(ServerTaskBundleNode.class);
    private static final boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    private static final boolean traceEnabled = log.isTraceEnabled();
    private static final AtomicLong INSTANCE_COUNT = new AtomicLong(0L);
    private final long id = INSTANCE_COUNT.incrementAndGet();
    private final ServerJob job;
    private final transient DataLocation dataProvider;
    private final transient List<ServerTask> taskList;
    private boolean requeued;
    private boolean cancelled;
    private boolean expired;
    private TaskBundle taskBundle;
    private ExecutorChannel<?> channel;
    private Future<?> future;
    private final int taskCount;
    private JobReturnReason jobReturnReason;
    private boolean offline;
    private final long dispatchStartTime;
    private TaskGraphInfo graphInfo;

    public ServerTaskBundleNode(ServerJob job, TaskBundle taskBundle, Collection<ServerTask> taskList) {
        if (job == null) {
            throw new IllegalArgumentException("job is null");
        }
        if (taskBundle == null) {
            throw new IllegalArgumentException("taskBundle is null");
        }
        if (taskList == null) {
            throw new IllegalArgumentException("taskList is null");
        }
        this.job = job;
        this.taskBundle = taskBundle;
        this.taskList = new ArrayList<ServerTask>(taskList);
        int size = this.taskList.size();
        this.taskBundle.setTaskCount(size);
        this.taskBundle.setCurrentTaskCount(size);
        this.dataProvider = job.getDataProvider();
        this.taskCount = size;
        this.dispatchStartTime = System.currentTimeMillis();
        this.taskBundle.setParameter((Object)"node.bundle.id", (Object)this.id);
        this.checkTaskCount();
        this.resolveDependencies();
    }

    public TaskBundle getJob() {
        return this.taskBundle;
    }

    public ServerJob getServerJob() {
        return this.job;
    }

    public ServerJob getClientJob() {
        return this.job;
    }

    public DataLocation getDataProvider() {
        return this.dataProvider;
    }

    public List<ServerTask> getTaskList() {
        return this.taskList;
    }

    public void setChannel(ExecutorChannel<?> channel) {
        if (channel == null) {
            throw new IllegalArgumentException("channel is null for " + this);
        }
        this.channel = channel;
    }

    public void jobDispatched(ExecutorChannel<?> channel, Future<?> future) {
        if (channel == null) {
            throw new IllegalArgumentException("channel is null for " + this);
        }
        if (future == null) {
            throw new IllegalArgumentException("future is null for " + this);
        }
        this.channel = channel;
        this.future = future;
        this.job.jobDispatched(this);
    }

    public void resultsReceived(List<DataLocation> results) {
        this.taskCompleted(null);
        this.job.resultsReceived(this, results);
        this.channel = null;
    }

    public void resultsReceived(Throwable throwable) {
        this.job.resultsReceived(this, throwable);
        this.taskCompleted(throwable);
        this.channel = null;
    }

    public void taskCompleted(Throwable exception) {
        if (debugEnabled && exception != null) {
            log.debug("received exception for {} :\n{}\ncall stack:\n{}", new Object[]{this, ExceptionUtils.getStackTrace((Throwable)exception), ExceptionUtils.getCallStack()});
        }
        try {
            this.job.jobReturned(this);
        }
        finally {
            this.future = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resubmit() {
        if (this.getJob().getSLA().isBroadcastJob()) {
            return;
        }
        ServerTaskBundleNode serverTaskBundleNode = this;
        synchronized (serverTaskBundleNode) {
            this.requeued = true;
            for (ServerTask task : this.taskList) {
                task.resubmit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expire() {
        if (this.getJob().getSLA().isBroadcastJob()) {
            return;
        }
        int max = this.job.getSLA().getMaxDispatchExpirations();
        ServerTaskBundleNode serverTaskBundleNode = this;
        synchronized (serverTaskBundleNode) {
            for (ServerTask task : this.taskList) {
                if (task.incExpirationCount() > max) {
                    task.cancel();
                    continue;
                }
                task.resubmit();
            }
            this.expired = true;
        }
    }

    public synchronized boolean isRequeued() {
        return this.requeued;
    }

    public synchronized void cancel() {
        this.cancelled = true;
        for (ServerTask task : this.taskList) {
            task.cancel();
        }
    }

    public synchronized boolean isCancelled() {
        return this.cancelled;
    }

    public synchronized boolean isExpired() {
        return this.expired;
    }

    public ExecutorChannel<?> getChannel() {
        return this.channel;
    }

    public Future<?> getFuture() {
        return this.future;
    }

    public void checkTaskCount() {
        if (this.taskCount != this.taskBundle.getTaskCount()) {
            throw new IllegalStateException("task counts do not match");
        }
    }

    public int getTaskCount() {
        return this.taskCount;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append('[');
        sb.append("id=").append(this.id);
        sb.append(", name=").append(this.job.getName());
        sb.append(", uuid=").append(this.job.getUuid());
        sb.append(", initialTaskCount=").append(this.job.getInitialTaskCount());
        sb.append(", taskCount=").append(this.taskCount);
        sb.append(", cancelled=").append(this.cancelled);
        sb.append(", requeued=").append(this.requeued);
        sb.append(", dependencies=").append(this.graphInfo == null ? 0 : this.graphInfo.getNbDependencies());
        sb.append(", channel=").append(this.channel);
        sb.append(']');
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServerTaskBundleNode other = (ServerTaskBundleNode)obj;
        return this.id == other.id;
    }

    public long getId() {
        return this.id;
    }

    public static String makeKey(ServerTaskBundleNode bundle) {
        return ServerTaskBundleNode.makeKey(bundle.getJob().getUuid(), bundle.getId());
    }

    public static String makeKey(String jobUuid, long bundleId) {
        return jobUuid + '|' + bundleId;
    }

    public JobReturnReason getJobReturnReason() {
        return this.jobReturnReason;
    }

    public void setJobReturnReason(JobReturnReason jobReturnReason) {
        this.jobReturnReason = jobReturnReason;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public void setOffline(boolean offline) {
        this.offline = offline;
    }

    public long getDispatchStartTime() {
        return this.dispatchStartTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveDependencies() {
        TaskGraph graph = this.job.getTaskGraph();
        this.job.lock.lock();
        try {
            HashSet<Integer> depsPositions = new HashSet<Integer>();
            HashSet<ServerTask> dependencies = new HashSet<ServerTask>();
            ArrayListHashMap dependenciesMap = new ArrayListHashMap();
            for (ServerTask task : this.taskList) {
                if (graph != null) {
                    List deps;
                    TaskGraph.Node node = graph.nodeAt(task.getPosition());
                    if (node == null) continue;
                    if (traceEnabled) {
                        log.trace("found node in graph for {}", (Object)task);
                    }
                    if ((deps = node.getDependencies()) == null || deps.isEmpty()) continue;
                    for (TaskGraph.Node dep : deps) {
                        ServerTask depTask = (ServerTask)this.job.tasks.get(dep.getPosition());
                        if (depTask == null) {
                            depTask = (ServerTask)this.job.dependendedOnTasks.get(dep.getPosition());
                        }
                        if (depTask == null) continue;
                        dependencies.add(depTask);
                        dependenciesMap.putValue((Object)task.getPosition(), (Object)dep.getPosition());
                    }
                    continue;
                }
                ServerTaskBundleClient clientBundle = task.getBundle();
                TaskGraphInfo clientGraphInfo = clientBundle.getTaskGraphInfo();
                if (clientGraphInfo != null) {
                    Collection positions;
                    if (traceEnabled) {
                        log.trace("found graph info for {}", (Object)task);
                    }
                    if ((positions = clientGraphInfo.getDependenciesMap().getValues((Object)task.getPosition())) == null) continue;
                    Iterator iterator = positions.iterator();
                    while (iterator.hasNext()) {
                        int position = (Integer)iterator.next();
                        ServerTask dep = (ServerTask)clientGraphInfo.getDependencyAt(position);
                        if (dep == null) continue;
                        dependencies.add(dep);
                        depsPositions.add(position);
                        dependenciesMap.putValue((Object)task.getPosition(), (Object)dep.getPosition());
                    }
                    continue;
                }
                if (!traceEnabled) continue;
                log.trace("no graph info found for {}", (Object)task);
            }
            if (!dependencies.isEmpty()) {
                ArrayList depsList = new ArrayList(dependencies);
                int[] positions = new int[depsList.size()];
                int count = 0;
                for (ServerTask task : depsList) {
                    positions[count++] = task.getPosition();
                }
                this.graphInfo = new TaskGraphInfo(depsList.size(), (CollectionMap)dependenciesMap, positions);
                this.graphInfo.setDependencies(depsList);
                if (debugEnabled) {
                    log.debug("there are {} dependencies in {}", (Object)this.graphInfo.getNbDependencies(), (Object)this);
                }
            } else if (debugEnabled) {
                log.debug("there are no dependencies in {}", (Object)this);
            }
        }
        finally {
            this.job.lock.unlock();
        }
    }

    public TaskGraphInfo getTaskGraphInfo() {
        return this.graphInfo;
    }
}

