/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.queue;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.jppf.execute.ExecutorChannel;
import org.jppf.execute.ExecutorStatus;
import org.jppf.job.AllJobsSelector;
import org.jppf.job.JobManagerListener;
import org.jppf.job.JobSelector;
import org.jppf.node.protocol.BundleParameter;
import org.jppf.node.protocol.JPPFDistributedJob;
import org.jppf.node.protocol.JobSLA;
import org.jppf.node.protocol.TaskBundle;
import org.jppf.queue.AbstractJPPFQueue;
import org.jppf.queue.JPPFQueue;
import org.jppf.queue.QueueEvent;
import org.jppf.server.JPPFDriver;
import org.jppf.server.job.JPPFJobManager;
import org.jppf.server.job.JobManager;
import org.jppf.server.nio.nodeserver.BaseNodeContext;
import org.jppf.server.protocol.JPPFJobEndedException;
import org.jppf.server.protocol.ServerJob;
import org.jppf.server.protocol.ServerTaskBundleClient;
import org.jppf.server.protocol.ServerTaskBundleNode;
import org.jppf.server.queue.BroadcastManager;
import org.jppf.server.queue.JobDependenciesHandler;
import org.jppf.server.queue.PersistenceHandler;
import org.jppf.server.queue.RemoveBundleAction;
import org.jppf.server.queue.RequeueBundleAction;
import org.jppf.server.queue.ScheduleManager;
import org.jppf.server.submission.SubmissionStatus;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.collections.CollectionMap;
import org.jppf.utils.collections.CollectionUtils;
import org.jppf.utils.collections.LinkedListSortedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPPFPriorityQueue
extends AbstractJPPFQueue<ServerJob, ServerTaskBundleClient, ServerTaskBundleNode>
implements JobManager {
    private static final Logger log = LoggerFactory.getLogger(JPPFPriorityQueue.class);
    private static final boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    final JPPFDriver driver;
    private final List<JobManagerListener> jobListeners = new ArrayList<JobManagerListener>();
    final ScheduleManager scheduleManager = new ScheduleManager();
    final JPPFJobManager jobManager;
    private final BroadcastManager broadcastManager;
    final PersistenceHandler persistenceHandler;
    private final Map<String, Condition> jobRemovalConditions = new HashMap<String, Condition>();
    private final JobDependenciesHandler dependenciesHandler;

    public JPPFPriorityQueue(JPPFDriver driver, JPPFJobManager jobManager) {
        this.driver = driver;
        this.jobManager = jobManager;
        this.broadcastManager = new BroadcastManager(this);
        this.persistenceHandler = new PersistenceHandler(this);
        this.dependenciesHandler = new JobDependenciesHandler(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerJob addBundle(ServerTaskBundleClient clientBundle) {
        if (debugEnabled) {
            log.debug("adding bundle=" + clientBundle);
        }
        if (clientBundle == null) {
            throw new IllegalArgumentException("clientBundle is null");
        }
        JobSLA sla = clientBundle.getSLA();
        String jobUuid = clientBundle.getUuid();
        ServerJob serverJob = null;
        boolean cancel = false;
        this.lock.lock();
        try {
            if (sla.isBroadcastJob()) {
                if (debugEnabled) {
                    log.debug("before processing broadcast job {}", (Object)clientBundle.getJob());
                }
                this.broadcastManager.processBroadcastJob(clientBundle);
            } else {
                TaskBundle header;
                boolean newJob = false;
                boolean done = false;
                boolean added = false;
                while (!done) {
                    serverJob = (ServerJob)this.jobMap.get(jobUuid);
                    if (serverJob == null) {
                        newJob = true;
                        serverJob = this.createServerJob(clientBundle);
                        if (debugEnabled) {
                            log.debug("created new {}", (Object)serverJob);
                        }
                        this.jobMap.put(jobUuid, serverJob);
                        this.jobManager.jobQueued(serverJob);
                    } else {
                        if (debugEnabled) {
                            log.debug("job already queued");
                        }
                        clientBundle.getJob().removeParameter((Object)BundleParameter.JOB_TASK_GRAPH);
                    }
                    try {
                        added = serverJob.addBundle(clientBundle);
                        done = true;
                    }
                    catch (JPPFJobEndedException e) {
                        if (debugEnabled) {
                            log.debug("caught {}, awaiting removal of {}", (Object)ExceptionUtils.getMessage((Throwable)((Object)e)), (Object)serverJob);
                        }
                        this.awaitJobRemoved(serverJob);
                    }
                }
                if (added) {
                    if (!newJob) {
                        this.priorityMap.removeValue((Object)sla.getPriority(), (Object)serverJob);
                    } else {
                        cancel = serverJob.getSLA().getDependencySpec().getId() != null && this.dependenciesHandler.jobQueued(serverJob);
                    }
                } else {
                    ServerJob e = serverJob;
                    return e;
                }
                if (!sla.isBroadcastJob() || serverJob.getBroadcastUUID() != null) {
                    this.priorityMap.putValue((Object)sla.getPriority(), (Object)serverJob);
                    this.incrementSizeCount(this.getSize(serverJob));
                }
                this.updateLatestMaxSize();
                if (!newJob) {
                    this.driver.getStatistics().addValue("job.tasks", (double)clientBundle.getTaskCount());
                }
                if (!((Boolean)(header = clientBundle.getJob()).getParameter((Object)BundleParameter.FROM_PERSISTENCE, (Object)false)).booleanValue() && !((Boolean)header.getParameter((Object)BundleParameter.ALREADY_PERSISTED, (Object)false)).booleanValue()) {
                    header.setParameter((Object)BundleParameter.ALREADY_PERSISTED, (Object)true);
                    this.persistenceHandler.storeJob(serverJob, clientBundle, !newJob);
                }
                if (!cancel) {
                    this.fireBundleAdded(new QueueEvent((JPPFQueue)this, (Object)serverJob, false));
                }
            }
            if (debugEnabled) {
                log.debug("Maps size information: {}", (Object)CollectionUtils.formatSizeMapInfo((String)"priorityMap", (CollectionMap)this.priorityMap));
            }
        }
        finally {
            this.lock.unlock();
        }
        this.driver.getStatistics().addValue("task.queue.total", (double)clientBundle.getTaskCount());
        this.driver.getStatistics().addValue("task.queue.count", (double)clientBundle.getTaskCount());
        if (cancel) {
            serverJob.cancel(this.driver, true);
        }
        return serverJob;
    }

    void awaitJobRemoved(ServerJob serverJob) {
        if (debugEnabled) {
            log.debug("awaiting removal of {}", (Object)serverJob);
        }
        String uuid = serverJob.getUuid();
        try {
            Condition cond = this.jobRemovalConditions.get(uuid);
            ServerJob job = null;
            while ((job = (ServerJob)this.jobMap.get(uuid)) != null && job.hasCompleted()) {
                if (cond == null) {
                    cond = this.lock.newCondition();
                    this.jobRemovalConditions.put(uuid, cond);
                }
                cond.await();
            }
            if (debugEnabled) {
                log.debug("finished waiting for removal of {}", (Object)serverJob);
            }
        }
        catch (InterruptedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private ServerJob createServerJob(ServerTaskBundleClient clientBundle) {
        TaskBundle header = clientBundle.getJob();
        header.setDriverQueueTaskCount(header.getTaskCount());
        ServerJob serverJob = new ServerJob(new ReentrantLock(), this.jobManager, header, clientBundle.getDataProvider());
        serverJob.setSubmissionStatus(SubmissionStatus.PENDING);
        serverJob.setQueueEntryTime(System.currentTimeMillis());
        serverJob.setJobReceivedTime(serverJob.getQueueEntryTime());
        serverJob.addOnDone(new RemoveBundleAction(this, serverJob));
        if (!clientBundle.getSLA().isBroadcastJob() || serverJob.getBroadcastUUID() != null) {
            if (debugEnabled) {
                log.debug("adding bundle with {}", (Object)clientBundle);
            }
            this.scheduleManager.handleStartJobSchedule(serverJob);
            this.scheduleManager.handleExpirationJobSchedule(this.driver, serverJob);
        }
        return serverJob;
    }

    void requeue(ServerJob job) {
        this.lock.lock();
        try {
            if (!this.jobMap.containsKey(job.getUuid())) {
                throw new IllegalStateException("Job " + job + " not managed");
            }
            if (debugEnabled) {
                log.debug("requeuing job {}", (Object)job);
            }
            this.priorityMap.putValue((Object)job.getSLA().getPriority(), (Object)job);
            this.incrementSizeCount(this.getSize(job));
            this.fireBundleAdded(new QueueEvent((JPPFQueue)this, (Object)job, true));
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerTaskBundleNode nextBundle(ServerJob serverJob, int nbTasks, ExecutorChannel<ServerTaskBundleNode> channel) {
        ServerTaskBundleNode result;
        this.lock.lock();
        try {
            int taskCount = serverJob.getTaskCount();
            if (debugEnabled) {
                log.debug("requesting bundle with {} tasks, next bundle has {} tasks", (Object)nbTasks, (Object)taskCount);
            }
            int size = this.getSize(serverJob);
            this.decrementSizeCount(size);
            int effectiveNbTasks = nbTasks;
            if (serverJob.getTaskGraph() != null) {
                effectiveNbTasks = Math.min(nbTasks, serverJob.getAvailableGraphNodeCount());
            }
            if (debugEnabled) {
                log.debug("nbTasks={}, effectiveNbTasks={}", (Object)nbTasks, (Object)effectiveNbTasks);
            }
            if (effectiveNbTasks >= taskCount) {
                if (taskCount <= 0) {
                    throw new IllegalStateException("no task to dispatch for job " + serverJob);
                }
                serverJob.setOnRequeue(new RequeueBundleAction(this, serverJob));
                result = serverJob.createNodeDispatch(taskCount);
                this.removeBundle(serverJob, false);
            } else {
                if (debugEnabled) {
                    log.debug("removing {} tasks from bundle", (Object)effectiveNbTasks);
                }
                result = serverJob.createNodeDispatch(effectiveNbTasks);
                this.incrementSizeCount(size);
                this.priorityMap.moveToEndOfList((Object)serverJob.getSLA().getPriority(), (Object)serverJob);
            }
            this.updateLatestMaxSize();
            if (debugEnabled) {
                log.debug("Maps size information: {}", (Object)CollectionUtils.formatSizeMapInfo((String)"priorityMap", (CollectionMap)this.priorityMap));
            }
        }
        finally {
            this.lock.unlock();
        }
        if (debugEnabled) {
            log.debug("found {} tasks in the job, result={}", (Object)result.getTaskCount(), (Object)result);
        }
        this.driver.getStatistics().addValue("task.queue.count", (double)(-result.getTaskCount()));
        this.driver.getStatistics().addValues("task.queue.time", (double)(System.currentTimeMillis() - serverJob.getQueueEntryTime()), (long)result.getTaskCount());
        return result;
    }

    public ServerJob removeBundle(ServerJob serverJob) {
        return this.removeBundle(serverJob, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerJob removeBundle(ServerJob serverJob, boolean removeFromJobMap) {
        if (serverJob == null) {
            throw new IllegalArgumentException("serverJob is null");
        }
        this.lock.lock();
        try {
            if (removeFromJobMap) {
                String uuid = serverJob.getUuid();
                if (this.jobMap.remove(uuid) != null) {
                    this.scheduleManager.clearSchedules(serverJob.getUuid());
                    if (serverJob.getSLA().getDependencySpec().getId() != null) {
                        this.dependenciesHandler.jobEnded(serverJob);
                    }
                    this.jobManager.jobEnded(serverJob);
                } else if (debugEnabled) {
                    log.debug("could not remove {}", (Object)serverJob);
                }
                Condition cond = this.jobRemovalConditions.remove(uuid);
                if (cond != null) {
                    cond.signalAll();
                }
            }
            if (debugEnabled) {
                log.debug("removing job from queue, jobName= {}, removeFromJobMap={}", (Object)serverJob.getName(), (Object)removeFromJobMap);
            }
            if (this.priorityMap.removeValue((Object)serverJob.getSLA().getPriority(), (Object)serverJob)) {
                for (ServerTaskBundleClient clientBundle : serverJob.getCompletionBundles()) {
                    if (debugEnabled) {
                        log.debug("adding completion bundle for job={} : {}", (Object)serverJob.getName(), (Object)clientBundle);
                    }
                    this.addBundle(clientBundle);
                }
            }
            this.fireBundleRemoved(new QueueEvent((JPPFQueue)this, (Object)serverJob, false));
        }
        finally {
            this.lock.unlock();
        }
        return serverJob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePriority(String jobUuid, int newPriority) {
        this.lock.lock();
        try {
            ServerJob job = (ServerJob)this.jobMap.get(jobUuid);
            if (job == null) {
                return;
            }
            int oldPriority = job.getSLA().getPriority();
            if (oldPriority != newPriority) {
                job.getSLA().setPriority(newPriority);
                this.priorityMap.removeValue((Object)oldPriority, (Object)job);
                this.priorityMap.putValue((Object)newPriority, (Object)job);
                job.fireJobUpdated(true);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancelJob(String jobId) {
        this.lock.lock();
        try {
            boolean res;
            ServerJob job = (ServerJob)this.jobMap.get(jobId);
            boolean bl = res = job != null;
            if (res) {
                this.decrementSizeCount(this.getSize(job));
                res &= job.cancel(this.driver, false);
            }
            boolean bl2 = res;
            return bl2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.lock.lock();
        try {
            this.scheduleManager.close();
            List list = this.queueListeners;
            synchronized (list) {
                this.queueListeners.clear();
            }
            this.priorityMap.clear();
            this.sizeMap.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    public ServerJob getJob(String jobId) {
        this.lock.lock();
        try {
            ServerJob serverJob = (ServerJob)this.jobMap.get(jobId);
            return serverJob;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerJob getJobFromPriorityMap(String jobId) {
        this.lock.lock();
        try {
            for (ServerJob job : this.priorityMap) {
                if (!job.getUuid().equals(jobId)) continue;
                ServerJob serverJob = job;
                return serverJob;
            }
            Iterator iterator = null;
            return iterator;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Set<String> getAllJobIds() {
        this.lock.lock();
        try {
            HashSet<String> hashSet = new HashSet<String>(this.jobMap.keySet());
            return hashSet;
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<ServerJob> getAllJobs() {
        this.lock.lock();
        try {
            ArrayList<ServerJob> arrayList = new ArrayList<ServerJob>(this.jobMap.values());
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getAllJobIdsFromPriorityMap() {
        this.lock.lock();
        try {
            HashSet<String> set = new HashSet<String>();
            for (ServerJob job : this.priorityMap.allValues()) {
                set.add(job.getUuid());
            }
            HashSet<String> hashSet = set;
            return hashSet;
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<ServerJob> getAllJobsFromPriorityMap() {
        this.lock.lock();
        try {
            List list = this.priorityMap.allValues();
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addJobListener(JobManagerListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener is null");
        }
        List<JobManagerListener> list = this.jobListeners;
        synchronized (list) {
            this.jobListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeJobListener(JobManagerListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener is null");
        }
        List<JobManagerListener> list = this.jobListeners;
        synchronized (list) {
            this.jobListeners.remove(listener);
        }
    }

    @Override
    public ServerJob getBundleForJob(String jobUuid) {
        return this.getJob(jobUuid);
    }

    protected int getSize(ServerJob job) {
        return job.getJob().getDriverQueueTaskCount();
    }

    Map<String, ServerJob> getJobMap() {
        return this.jobMap;
    }

    LinkedListSortedMap<Integer, ServerJob> getPriorityMap() {
        return this.priorityMap;
    }

    public void setCallableAllConnections(Callable<List<BaseNodeContext>> callableAllConnections) {
        this.broadcastManager.setCallableAllConnections(callableAllConnections);
    }

    public void updateWorkingConnections(ExecutorStatus oldStatus, ExecutorStatus newStatus) {
        this.broadcastManager.updateWorkingConnections(oldStatus, newStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ServerJob> selectJobs(JobSelector selector) {
        if (selector == null || selector instanceof AllJobsSelector) {
            return this.getAllJobs();
        }
        ArrayList<ServerJob> list = new ArrayList<ServerJob>();
        this.lock.lock();
        try {
            for (ServerJob job : this.jobMap.values()) {
                if (!selector.accepts((JPPFDistributedJob)job)) continue;
                list.add(job);
            }
        }
        finally {
            this.lock.unlock();
        }
        return list;
    }

    public void updateSchedules(ServerJob job) {
        JobSLA sla = job.getSLA();
        this.scheduleManager.clearSchedules(job.getUuid());
        if (sla.getJobSchedule() != null) {
            this.scheduleManager.handleStartJobSchedule(job);
        }
        if (sla.getJobExpirationSchedule() != null) {
            this.scheduleManager.handleExpirationJobSchedule(this.driver, job);
        }
    }

    public BroadcastManager getBroadcastManager() {
        return this.broadcastManager;
    }

    public PersistenceHandler getPersistenceHandler() {
        return this.persistenceHandler;
    }

    public JobDependenciesHandler getDependenciesHandler() {
        return this.dependenciesHandler;
    }
}

