/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.queue;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jppf.node.protocol.JobDependencySpec;
import org.jppf.node.protocol.graph.JPPFJobDependencyCycleException;
import org.jppf.node.protocol.graph.JobDependencyNode;
import org.jppf.node.protocol.graph.MutableJobDependencyGraph;
import org.jppf.server.protocol.ServerJob;
import org.jppf.server.queue.JPPFPriorityQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobDependenciesHandler {
    private static final Logger log = LoggerFactory.getLogger(JobDependenciesHandler.class);
    private static final boolean debugEnabled = log.isDebugEnabled();
    private final MutableJobDependencyGraph graph = new MutableJobDependencyGraph();
    private final JPPFPriorityQueue queue;

    public JobDependenciesHandler(JPPFPriorityQueue queue) {
        this.queue = queue;
    }

    public boolean jobQueued(ServerJob job) {
        JobDependencySpec spec = job.getSLA().getDependencySpec();
        if (spec.getId() != null) {
            try {
                JobDependencyNode node = this.graph.addNode(spec, job.getUuid());
                if (debugEnabled) {
                    log.debug("'{}' was queued and added to the dependency graph as {}", (Object)job.getName(), (Object)node);
                }
                return node.isCancelled();
            }
            catch (JPPFJobDependencyCycleException e) {
                List<String> toCancel;
                JobDependencyNode node = this.graph.getNode(spec.getId());
                log.error("detected dependency cycle when queuing {}, spec = {}", new Object[]{job, spec, e});
                if (node != null) {
                    node.setGraphRoot(true);
                }
                if ((toCancel = e.getIdPath()) == null) {
                    toCancel = Collections.singletonList(spec.getId());
                } else {
                    toCancel.add(spec.getId());
                }
                if (debugEnabled) {
                    log.debug("cycle id path: {}", toCancel);
                }
                this.cancelNodes(toCancel);
            }
        }
        return true;
    }

    public void jobEnded(ServerJob job) {
        JobDependencyNode node;
        if (debugEnabled) {
            log.debug("processor: '{}' has ended", (Object)job.getName());
        }
        List toResume = this.graph.jobEnded(job.getUuid());
        if (debugEnabled && toResume != null) {
            for (JobDependencyNode jobNode : toResume) {
                log.debug("resuming '{}'", (Object)jobNode.getId());
            }
        }
        if ((node = this.graph.getNodeByJobUuid(job.getUuid())) == null) {
            node = this.graph.getNode(job.getSLA().getDependencySpec().getId());
        }
        if (debugEnabled) {
            log.debug("node ended: {}", (Object)node);
        }
        if (node != null && node.isGraphRoot()) {
            this.graph.removeNode(node);
        }
    }

    public boolean hasPendingDependencyOrCancelled(String id) {
        JobDependencyNode node = this.graph.getNode(id);
        return node != null && (node.hasPendingDependency() || node.isCancelled());
    }

    public void jobCancelled(ServerJob job) {
        JobDependencySpec spec = job.getSLA().getDependencySpec();
        if (spec.getId() != null && spec.isCascadeCancellation()) {
            JobDependencyNode node;
            if (debugEnabled) {
                log.debug("handling cancellation of {}", (Object)job);
            }
            if ((node = this.graph.getNode(spec.getId())) != null) {
                List<String> toCancel = this.processCancellation(node);
                if (debugEnabled) {
                    log.debug("cancelling dependent jobs {}", toCancel);
                }
                for (String uuid : toCancel) {
                    ServerJob dependentJob = this.queue.getJob(uuid);
                    if (dependentJob == null) continue;
                    dependentJob.cancel(this.queue.driver, true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> processCancellation(JobDependencyNode node) {
        ArrayList<String> toCancel = new ArrayList<String>();
        MutableJobDependencyGraph mutableJobDependencyGraph = this.graph;
        synchronized (mutableJobDependencyGraph) {
            Collection dependedOn = node.getDependedOn();
            if (dependedOn != null) {
                for (JobDependencyNode dependent : dependedOn) {
                    if (debugEnabled) {
                        log.debug("cancelling {}", (Object)dependent);
                    }
                    if (!dependent.isCompleted() && !dependent.isCancelled() && dependent.getJobUuid() != null) {
                        toCancel.add(dependent.getJobUuid());
                    }
                    dependent.setCancelled(true);
                }
            }
        }
        return toCancel;
    }

    public MutableJobDependencyGraph getGraph() {
        return this.graph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelNodes(List<String> nodeIds) {
        if (debugEnabled) {
            log.debug("cancelling nodes {}", nodeIds);
        }
        ArrayList<String> toCancel = new ArrayList<String>();
        MutableJobDependencyGraph mutableJobDependencyGraph = this.graph;
        synchronized (mutableJobDependencyGraph) {
            for (String id : nodeIds) {
                JobDependencyNode node = this.graph.getNode(id);
                if (node == null) continue;
                if (debugEnabled) {
                    log.debug("cancelling {}", (Object)node);
                }
                if (!node.isCompleted() && !node.isCancelled() && node.getJobUuid() != null) {
                    toCancel.add(node.getJobUuid());
                }
                node.setCancelled(true);
                node.setGraphRoot(true);
            }
        }
        if (debugEnabled) {
            log.debug("cancelling jobs {}", toCancel);
        }
        for (String uuid : toCancel) {
            ServerJob job = this.queue.getJob(uuid);
            if (job == null) continue;
            job.cancel(this.queue.driver, true);
        }
    }
}

