/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.queue;

import org.jppf.server.JPPFDriver;
import org.jppf.server.protocol.ServerJob;
import org.jppf.utils.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JobExpirationAction
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(JobExpirationAction.class);
    private static final boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    private final ServerJob serverJob;
    private final JPPFDriver driver;

    public JobExpirationAction(JPPFDriver driver, ServerJob serverJob) {
        if (serverJob == null) {
            throw new IllegalArgumentException("bundleWrapper is null");
        }
        this.driver = driver;
        this.serverJob = serverJob;
    }

    @Override
    public void run() {
        String jobId = this.serverJob.getName();
        try {
            if (debugEnabled) {
                log.debug("job '" + jobId + "' is expiring");
            }
            this.serverJob.jobExpired();
            this.serverJob.cancel(this.driver, true);
        }
        catch (Exception e) {
            log.error("Error while cancelling job id = " + jobId, (Throwable)e);
        }
    }
}

