/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.queue;

import org.jppf.server.protocol.ServerJob;
import org.jppf.utils.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JobScheduleAction
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(JobScheduleAction.class);
    private static final boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    private final ServerJob bundleWrapper;

    public JobScheduleAction(ServerJob bundleWrapper) {
        if (bundleWrapper == null) {
            throw new IllegalArgumentException("bundleWrapper is null");
        }
        this.bundleWrapper = bundleWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ServerJob serverJob = this.bundleWrapper;
        synchronized (serverJob) {
            if (debugEnabled) {
                String jobId = this.bundleWrapper.getName();
                log.debug("job '" + jobId + "' is resuming");
            }
            this.bundleWrapper.setPending(false);
        }
    }
}

