/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.queue;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jppf.io.DataLocation;
import org.jppf.io.FileDataLocation;
import org.jppf.io.IOHelper;
import org.jppf.job.persistence.JobPersistence;
import org.jppf.job.persistence.JobPersistenceException;
import org.jppf.job.persistence.JobPersistenceFactory;
import org.jppf.job.persistence.PersistenceInfo;
import org.jppf.job.persistence.PersistenceInfoImpl;
import org.jppf.job.persistence.PersistenceObjectType;
import org.jppf.node.protocol.BundleParameter;
import org.jppf.node.protocol.JPPFDistributedJob;
import org.jppf.node.protocol.TaskBundle;
import org.jppf.server.protocol.ServerJob;
import org.jppf.server.protocol.ServerTask;
import org.jppf.server.protocol.ServerTaskBundleClient;
import org.jppf.server.queue.JPPFPriorityQueue;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.FileUtils;
import org.jppf.utils.StringUtils;
import org.jppf.utils.TypedProperties;
import org.jppf.utils.streams.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceHandler {
    private static final Logger log = LoggerFactory.getLogger(PersistenceHandler.class);
    private static final boolean debugEnabled = log.isDebugEnabled();
    private final JobPersistence persistence;
    private final JPPFPriorityQueue queue;

    public PersistenceHandler(JPPFPriorityQueue queue) {
        this.queue = queue;
        this.persistence = JobPersistenceFactory.newInstance((TypedProperties)queue.driver.getConfiguration()).getPersistence();
    }

    void storeJob(ServerJob job, ServerTaskBundleClient clientBundle, boolean tasksOnly) {
        if (!this.isPersistent(job)) {
            return;
        }
        long start = System.nanoTime();
        try {
            if (debugEnabled) {
                log.debug("persisting {} job {}", (Object)(tasksOnly ? "existing" : "new"), (Object)job);
            }
            List<ServerTask> taskList = clientBundle.getTaskList();
            ArrayList<PersistenceInfoImpl> infos = new ArrayList<PersistenceInfoImpl>(taskList.size() + (tasksOnly ? 0 : 2));
            if (!tasksOnly) {
                infos.add(new PersistenceInfoImpl(job.getUuid(), (JPPFDistributedJob)job.getJob(), PersistenceObjectType.JOB_HEADER, -1, IOHelper.serializeData((Object)job.getJob())));
                infos.add(new PersistenceInfoImpl(job.getUuid(), (JPPFDistributedJob)job.getJob(), PersistenceObjectType.DATA_PROVIDER, -1, clientBundle.getDataProvider()));
            }
            for (ServerTask task : taskList) {
                DataLocation dl = IOHelper.serializeData((Object)task);
                infos.add(new PersistenceInfoImpl(job.getUuid(), (JPPFDistributedJob)job.getJob(), PersistenceObjectType.TASK, task.getPosition(), dl));
            }
            this.persistence.store(infos);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        long elapsed = (System.nanoTime() - start) / 1000000L;
        if (debugEnabled) {
            log.debug(String.format("took %,d ms to store job %s", elapsed, job.getName()));
        }
    }

    public void updateJobHeader(ServerJob job) {
        if (!this.isPersistent(job)) {
            return;
        }
        try {
            if (debugEnabled) {
                log.debug("updating header for job {}", (Object)job);
            }
            DataLocation data = IOHelper.serializeData((Object)job.getJob());
            this.persistence.store(Arrays.asList(new PersistenceInfoImpl(job.getUuid(), (JPPFDistributedJob)job.getJob(), PersistenceObjectType.JOB_HEADER, -1, data)));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void storeResults(ServerJob job, Collection<ServerTask> tasks) {
        if (!this.isPersistent(job)) {
            return;
        }
        try {
            if (debugEnabled) {
                log.debug("persisting {} results for job {}", (Object)tasks.size(), (Object)job);
            }
            ArrayList<PersistenceInfoImpl> infos = new ArrayList<PersistenceInfoImpl>(tasks.size());
            for (ServerTask task : tasks) {
                infos.add(new PersistenceInfoImpl(job.getUuid(), (JPPFDistributedJob)job.getJob(), PersistenceObjectType.TASK_RESULT, task.getPosition(), task.getResult()));
            }
            this.persistence.store(infos);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    void deleteJob(ServerJob job) {
        if (this.isPersistent(job)) {
            this.deleteJob(job.getUuid());
        }
    }

    public void deleteJob(String jobUuid) {
        if (!this.isPersistenceReady()) {
            return;
        }
        if (debugEnabled) {
            log.debug("removing job {} from persistence store", (Object)jobUuid);
        }
        try {
            this.persistence.deleteJob(jobUuid);
        }
        catch (JobPersistenceException e) {
            log.error("error deleting persistent job {} : {}", (Object)jobUuid, (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    private ServerTaskBundleClient loadJob(String jobUuid, boolean useAutoExecuteOnRestart) {
        if (this.persistence == null) {
            return null;
        }
        if (debugEnabled) {
            log.debug("loading job with uuid = {}", (Object)jobUuid);
        }
        try {
            TaskBundle header = this.loadHeader(jobUuid);
            if (header == null) {
                return null;
            }
            if (useAutoExecuteOnRestart && !header.getSLA().getPersistenceSpec().isAutoExecuteOnRestart()) {
                if (debugEnabled) {
                    log.debug("job with uuid = {} has autoExecuteOnRestart=false, it will not be loaded", (Object)jobUuid);
                }
                return null;
            }
            header.setParameter((Object)BundleParameter.FROM_PERSISTENCE, (Object)true);
            int[] taskPositions = this.persistence.getTaskPositions(jobUuid);
            Arrays.sort(taskPositions);
            int[] resultPositions = this.persistence.getTaskResultPositions(jobUuid);
            Arrays.sort(resultPositions);
            if (Arrays.equals(taskPositions, resultPositions) && header.getSLA().getPersistenceSpec().isDeleteOnCompletion()) {
                if (debugEnabled) {
                    log.debug("job already has completed: {}", (Object)header);
                }
                if (header.getSLA().getPersistenceSpec().isDeleteOnCompletion()) {
                    this.persistence.deleteJob(jobUuid);
                }
                return null;
            }
            int[] positionsToLoad = new int[taskPositions.length - resultPositions.length];
            if (debugEnabled) {
                log.debug("{} missing results for job {}", (Object)positionsToLoad, (Object)header);
            }
            int i = 0;
            for (int pos : taskPositions) {
                if (Arrays.binarySearch(resultPositions, pos) >= 0) continue;
                positionsToLoad[i++] = pos;
            }
            if (debugEnabled) {
                log.debug("positions to load for jobUuid={} : {}", (Object)jobUuid, (Object)StringUtils.buildString((int[])positionsToLoad));
            }
            ArrayList<PersistenceInfoImpl> infos = new ArrayList<PersistenceInfoImpl>(positionsToLoad.length + 1);
            infos.add(new PersistenceInfoImpl(jobUuid, (JPPFDistributedJob)header, PersistenceObjectType.DATA_PROVIDER, -1, null));
            for (int pos : positionsToLoad) {
                infos.add(new PersistenceInfoImpl(jobUuid, (JPPFDistributedJob)header, PersistenceObjectType.TASK, pos, null));
            }
            List streams = this.persistence.load(infos);
            DataLocation dataProvider = PersistenceHandler.load((InputStream)streams.get(0));
            ArrayList<ServerTask> pendingTasks = new ArrayList<ServerTask>(taskPositions.length - resultPositions.length);
            for (i = 1; i < streams.size(); ++i) {
                DataLocation taskData = PersistenceHandler.load((InputStream)streams.get(i));
                ServerTask task = (ServerTask)IOHelper.unwrappedData((DataLocation)taskData);
                pendingTasks.add(task);
            }
            return new ServerTaskBundleClient(pendingTasks, header, dataProvider);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void loadPersistedJobs() {
        if (this.persistence == null) {
            return;
        }
        try {
            if (debugEnabled) {
                log.debug("loading persisted jobs");
            }
            List uuids = this.persistence.getPersistedJobUuids();
            for (String uuid : uuids) {
                try {
                    ServerTaskBundleClient bundle = this.loadJob(uuid, true);
                    if (bundle == null) continue;
                    this.queue.addBundle(bundle);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public DataLocation load(PersistenceInfo info) throws Exception {
        List<DataLocation> list = this.load(Arrays.asList(info));
        return list == null || list.isEmpty() ? null : list.get(0);
    }

    public List<DataLocation> load(Collection<PersistenceInfo> infos) throws Exception {
        long start = System.nanoTime();
        ArrayList<DataLocation> result = null;
        List list = this.persistence.load(infos);
        if (list != null && !list.isEmpty()) {
            result = new ArrayList<DataLocation>(infos.size());
            for (InputStream is : list) {
                result.add(PersistenceHandler.load(is));
            }
        }
        long elapsed = (System.nanoTime() - start) / 1000000L;
        if (debugEnabled) {
            log.debug("took {} ms to load {} job elements", (Object)elapsed, (Object)infos.size());
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    private static DataLocation load(InputStream stream) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public TaskBundle loadHeader(String jobUuid) throws Exception {
        if (!this.isJobPersisted(jobUuid)) {
            return null;
        }
        return (TaskBundle)IOHelper.unwrappedData((DataLocation)this.load((PersistenceInfo)new PersistenceInfoImpl(jobUuid, null, PersistenceObjectType.JOB_HEADER, -1, null)));
    }

    public DataLocation loadToDisk(PersistenceInfo info) throws Exception {
        File dir = FileUtils.getJPPFTempDir();
        File file = File.createTempFile(info.getType().name(), ".tmp", dir);
        List list = this.persistence.load(Arrays.asList(info));
        if (list == null || list.isEmpty()) {
            return null;
        }
        try (InputStream is = (InputStream)list.get(0);
             BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));){
            StreamUtils.copyStream((InputStream)is, (OutputStream)os, (boolean)false);
        }
        return new FileDataLocation(file);
    }

    private boolean isPersistent(ServerJob job) {
        return this.isPersistenceReady() && job.isPersistent() && (Boolean)job.getJob().getParameter((Object)BundleParameter.ALREADY_PERSISTED, (Object)false) != false && (Boolean)job.getJob().getParameter((Object)BundleParameter.ALREADY_PERSISTED_P2P, (Object)false) == false;
    }

    public boolean isJobPersisted(String uuid) throws JobPersistenceException {
        return this.isPersistenceReady() && this.persistence.isJobPersisted(uuid);
    }

    private boolean isPersistenceReady() {
        return this.persistence != null && !this.queue.driver.isShuttingDown();
    }

    public JobPersistence getPersistence() {
        return this.persistence;
    }

    public int[][] getPersistedJobPositions(String uuid) throws Exception {
        int[] taskPositions;
        if (!this.isPersistenceReady()) {
            return null;
        }
        if (debugEnabled) {
            log.debug("requesting positions for uuid={}", (Object)uuid);
        }
        if ((taskPositions = this.persistence.getTaskPositions(uuid)) == null) {
            taskPositions = new int[]{};
        } else {
            Arrays.sort(taskPositions);
        }
        int[] resultPositions = this.persistence.getTaskResultPositions(uuid);
        if (resultPositions == null) {
            resultPositions = new int[]{};
        }
        Arrays.sort(resultPositions);
        return new int[][]{taskPositions, resultPositions};
    }

    public List<String> getPersistedJobUuids() throws JobPersistenceException {
        return this.isPersistenceReady() ? this.persistence.getPersistedJobUuids() : new ArrayList();
    }
}

