/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.queue;

import org.jppf.server.protocol.ServerJob;
import org.jppf.server.queue.JPPFPriorityQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RemoveBundleAction
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(RemoveBundleAction.class);
    private static final boolean debugEnabled = log.isDebugEnabled();
    private final JPPFPriorityQueue queue;
    private final ServerJob serverJob;

    public RemoveBundleAction(JPPFPriorityQueue queue, ServerJob serverJob) {
        if (queue == null) {
            throw new IllegalArgumentException("queue is null");
        }
        if (serverJob == null) {
            throw new IllegalArgumentException("serverJob is null");
        }
        if (debugEnabled) {
            log.debug("new RemoveBundleAction for job {}", (Object)serverJob);
        }
        this.queue = queue;
        this.serverJob = serverJob;
    }

    @Override
    public void run() {
        if (debugEnabled) {
            log.debug("removing {}", (Object)this.serverJob);
        }
        try {
            this.queue.removeBundle(this.serverJob, true);
            if (this.serverJob.getSLA().getPersistenceSpec().isDeleteOnCompletion()) {
                this.queue.getPersistenceHandler().deleteJob(this.serverJob);
            }
        }
        finally {
            this.serverJob.getRemovalCondition().wakeUp();
        }
    }
}

