/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.queue;

import java.text.ParseException;
import org.jppf.scheduling.JPPFSchedule;
import org.jppf.scheduling.JPPFScheduleHandler;
import org.jppf.server.JPPFDriver;
import org.jppf.server.protocol.ServerJob;
import org.jppf.server.queue.JobExpirationAction;
import org.jppf.server.queue.JobScheduleAction;
import org.jppf.utils.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ScheduleManager {
    private static final Logger log = LoggerFactory.getLogger(ScheduleManager.class);
    private static final boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    private final JPPFScheduleHandler jobStartHandler = new JPPFScheduleHandler("Job Schedule Handler");
    private final JPPFScheduleHandler jobExpirationHandler = new JPPFScheduleHandler("Job Expiration Handler");

    ScheduleManager() {
    }

    void handleStartJobSchedule(ServerJob serverJob) {
        String uuid = serverJob.getUuid();
        if (this.jobStartHandler.hasAction(uuid)) {
            return;
        }
        JPPFSchedule schedule = serverJob.getSLA().getJobSchedule();
        if (schedule != null) {
            serverJob.setPending(true);
            String jobId = serverJob.getName();
            if (debugEnabled) {
                log.debug("found start " + schedule + " for jobId = " + jobId);
            }
            try {
                long dt = serverJob.getJobReceivedTime();
                this.jobStartHandler.scheduleAction((Object)uuid, schedule, (Runnable)new JobScheduleAction(serverJob), dt);
            }
            catch (ParseException e) {
                serverJob.setPending(false);
                log.error("Unparseable start date for job id " + jobId + " : date = " + schedule.getDate() + ", date format = " + (schedule.getFormat() == null ? "null" : schedule.getFormat()), (Throwable)e);
            }
        } else {
            serverJob.setPending(false);
        }
    }

    void handleExpirationJobSchedule(JPPFDriver driver, ServerJob serverJob) {
        String uuid = serverJob.getUuid();
        if (this.jobExpirationHandler.hasAction(uuid)) {
            return;
        }
        JPPFSchedule schedule = serverJob.getSLA().getJobExpirationSchedule();
        if (schedule != null) {
            String jobId = serverJob.getName();
            if (debugEnabled) {
                log.debug("found expiration " + schedule + " for jobId = " + jobId);
            }
            long dt = serverJob.getJobReceivedTime();
            try {
                this.jobExpirationHandler.scheduleAction((Object)uuid, schedule, (Runnable)new JobExpirationAction(driver, serverJob), dt);
            }
            catch (ParseException e) {
                log.error("Unparsable expiration date for job id " + jobId + " : date = " + schedule.getDate() + ", date format = " + (schedule.getFormat() == null ? "null" : schedule.getFormat()), (Throwable)e);
            }
        }
    }

    void clearSchedules(String jobUuid) {
        this.jobStartHandler.cancelAction((Object)jobUuid);
        this.jobExpirationHandler.cancelAction((Object)jobUuid);
    }

    void close() {
        this.jobStartHandler.clear(true);
        this.jobExpirationHandler.clear(true);
    }
}

