/*
 * Decompiled with CFR 0.152.
 */
package org.jpy;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

class Assignment {
    private static final Map<Class<?>, Class<?>> boxedToPrimitive = new HashMap();

    Assignment() {
    }

    static Optional<Class<?>> getUnboxedType(Class<?> clazz) {
        return Optional.ofNullable(boxedToPrimitive.get(clazz));
    }

    static boolean isAssignableFrom(Class<?> signatureType, Object instance) {
        return Assignment.isAssignableFrom(signatureType, instance.getClass());
    }

    static boolean isAssignableFrom(Class<?> signatureType, Class<?> instanceType) {
        if (signatureType.isAssignableFrom(instanceType)) {
            return true;
        }
        if (signatureType.isPrimitive()) {
            return Assignment.getUnboxedType(instanceType).filter(signatureType::isAssignableFrom).isPresent();
        }
        return false;
    }

    static {
        boxedToPrimitive.put(Boolean.class, Boolean.TYPE);
        boxedToPrimitive.put(Byte.class, Byte.TYPE);
        boxedToPrimitive.put(Character.class, Character.TYPE);
        boxedToPrimitive.put(Short.class, Short.TYPE);
        boxedToPrimitive.put(Integer.class, Integer.TYPE);
        boxedToPrimitive.put(Long.class, Long.TYPE);
        boxedToPrimitive.put(Float.class, Float.TYPE);
        boxedToPrimitive.put(Double.class, Double.TYPE);
    }
}

