/*
 * Decompiled with CFR 0.152.
 */
package org.jpy;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jpy.KeyError;
import org.jpy.PyLib;
import org.jpy.PyObject;

public class PyDictWrapper
implements Map<PyObject, PyObject>,
AutoCloseable {
    private final PyObject pyObject;

    PyDictWrapper(PyObject pyObject) {
        this.pyObject = pyObject;
    }

    @Override
    public void close() {
        this.pyObject.close();
    }

    @Override
    public int size() {
        try (PyObject pyObj = this.pyObject.callMethod("__len__", new Object[0]);){
            int n = pyObj.getIntValue();
            return n;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return PyLib.pyDictContains(this.pyObject.getPointer(), key, null);
    }

    public boolean containsKey(String key) {
        return PyLib.pyDictContains(this.pyObject.getPointer(), key, String.class);
    }

    public boolean containsKey(PyObject key) {
        return PyLib.pyDictContains(this.pyObject.getPointer(), key, PyObject.class);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    @Override
    public PyObject get(Object key) {
        try {
            return this.getItem(key);
        }
        catch (KeyError e) {
            return null;
        }
    }

    public PyObject get(String key) {
        return this.get((Object)key);
    }

    @Override
    public PyObject put(PyObject key, PyObject value) {
        PyObject previous;
        try {
            previous = this.getItem(key);
        }
        catch (KeyError e) {
            previous = null;
        }
        this.setItem(key, value);
        return previous;
    }

    public PyObject getItem(Object key) throws KeyError {
        return this.pyObject.callMethod("__getitem__", key);
    }

    public void setItem(Object key, Object value) {
        PyObject result = this.pyObject.callMethod("__setitem__", key, value);
        Throwable throwable = null;
        if (result != null) {
            if (throwable != null) {
                try {
                    result.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                result.close();
            }
        }
    }

    public void putObject(Object key, Object value) {
        this.setItem(key, value);
    }

    public void delItem(Object key) {
        PyObject result = this.pyObject.callMethod("__delitem__", key);
        Throwable throwable = null;
        if (result != null) {
            if (throwable != null) {
                try {
                    result.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                result.close();
            }
        }
    }

    @Override
    public PyObject remove(Object key) {
        PyObject existing = this.get(key);
        if (existing != null) {
            this.delItem(key);
        }
        return existing;
    }

    public PyObject remove(String key) {
        return this.remove((Object)key);
    }

    @Override
    public void putAll(Map<? extends PyObject, ? extends PyObject> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        PyObject pyObj = this.pyObject.callMethod("clear", new Object[0]);
        Throwable throwable = null;
        if (pyObj != null) {
            if (throwable != null) {
                try {
                    pyObj.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                pyObj.close();
            }
        }
    }

    @Override
    public Set<PyObject> keySet() {
        try (PyObject pyObj = PyLib.pyDictKeys(this.pyObject.getPointer());){
            LinkedHashSet<PyObject> linkedHashSet = new LinkedHashSet<PyObject>(pyObj.asList());
            return linkedHashSet;
        }
    }

    @Override
    public Collection<PyObject> values() {
        return PyLib.pyDictValues(this.pyObject.getPointer()).asList();
    }

    @Override
    public Set<Map.Entry<PyObject, PyObject>> entrySet() {
        try (PyObject pyObj = PyLib.pyDictKeys(this.pyObject.getPointer());){
            Set set = pyObj.asList().stream().map(p -> new AbstractMap.SimpleImmutableEntry<PyObject, PyObject>((PyObject)p, this.get(p))).collect(Collectors.toCollection(LinkedHashSet::new));
            return set;
        }
    }

    public PyObject unwrap() {
        return this.pyObject;
    }

    long getPointer() {
        return this.pyObject.getPointer();
    }

    public PyDictWrapper copy() {
        return new PyDictWrapper(PyLib.copyDict(this.pyObject.getPointer()));
    }
}

