/*
 * Decompiled with CFR 0.152.
 */
package org.jpy;

import java.util.Objects;
import org.jpy.PyLib;

public class PyLibInitializer {
    static boolean pyLibInitialized = false;
    static boolean dlInitialized = false;

    public static boolean isPyLibInitialized() {
        return pyLibInitialized;
    }

    public static boolean isDlInitialized() {
        return dlInitialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initPyLib(String pyLib, String jpyLib, String jdlLib) {
        Class<PyLibInitializer> clazz = PyLibInitializer.class;
        synchronized (PyLibInitializer.class) {
            System.setProperty("jpy.pythonLib", pyLib);
            System.setProperty("jpy.jpyLib", jpyLib);
            System.setProperty("jpy.jdlLib", jdlLib);
            PyLibInitializer.ensurePyLibInit();
            PyLibInitializer.ensurePropertySame("jpy.pythonLib", pyLib);
            PyLibInitializer.ensurePropertySame("jpy.jpyLib", jpyLib);
            PyLibInitializer.ensurePropertySame("jpy.jdlLib", jdlLib);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private static void ensurePyLibInit() {
        if (pyLibInitialized) {
            throw new IllegalStateException("PyLib is already initialized");
        }
        if (dlInitialized) {
            throw new IllegalStateException("DL is already initialized");
        }
        PyLib.dummyMethodForInitialization();
        if (!pyLibInitialized) {
            throw new IllegalStateException("PyLib should have been initialized. This should not happen.");
        }
    }

    private static void ensurePropertySame(String propertyName, String propertyValue) {
        String currentValue = System.getProperty(propertyName);
        if (!Objects.equals(propertyValue, currentValue)) {
            throw new IllegalStateException(String.format("PyLib initialization has changed the value of system property '%s': was '%s', is now '%s'", propertyName, propertyValue, currentValue));
        }
    }
}

