/*
 * Decompiled with CFR 0.152.
 */
package org.jpy;

import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.jpy.PyLib;

final class PyObjectState
implements AutoCloseable {
    private static final AtomicLongFieldUpdater<PyObjectState> updater = AtomicLongFieldUpdater.newUpdater(PyObjectState.class, "pointer");
    private volatile long pointer;

    PyObjectState(long pointer) {
        if (pointer == 0L) {
            throw new IllegalArgumentException("pointer == 0");
        }
        this.pointer = pointer;
    }

    public final long borrowPointer() {
        long localPointer = updater.get(this);
        if (localPointer == 0L) {
            throw new IllegalStateException("PyObjectState has already been taken");
        }
        return localPointer;
    }

    final long takePointer() {
        long localPointer = updater.get(this);
        if (localPointer == 0L) {
            return 0L;
        }
        if (!updater.compareAndSet(this, localPointer, 0L)) {
            return 0L;
        }
        return localPointer;
    }

    @Override
    public void close() {
        long pointerForClosure = this.takePointer();
        if (pointerForClosure == 0L) {
            return;
        }
        PyLib.decRef(pointerForClosure);
    }
}

