/*
 * Decompiled with CFR 0.152.
 */
package org.jpy.jsr223;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import org.jpy.jsr223.ScriptEngineImpl;

public class ScriptEngineFactoryImpl
implements ScriptEngineFactory {
    private final Map<String, Object> parameters = new HashMap<String, Object>();
    private ScriptEngineImpl scriptEngine;

    public ScriptEngineFactoryImpl() {
        this.parameters.put("javax.script.name", this.getNames().get(0));
        this.parameters.put("javax.script.engine", this.getEngineName());
        this.parameters.put("javax.script.engine_version", this.getEngineVersion());
        this.parameters.put("javax.script.language", this.getLanguageName());
        this.parameters.put("javax.script.language_version", this.getLanguageVersion());
    }

    @Override
    public String getEngineName() {
        return "jpy Python Engine";
    }

    @Override
    public String getEngineVersion() {
        return "0.1-alpha";
    }

    @Override
    public List<String> getExtensions() {
        return Collections.unmodifiableList(Arrays.asList("py", "pyc"));
    }

    @Override
    public List<String> getMimeTypes() {
        return Collections.unmodifiableList(Arrays.asList("text/python", "application/python", "text/x-python", "application/x-python"));
    }

    @Override
    public List<String> getNames() {
        return Collections.unmodifiableList(Arrays.asList("cpython", "python"));
    }

    @Override
    public String getLanguageName() {
        return "python";
    }

    @Override
    public String getLanguageVersion() {
        return "3.x";
    }

    @Override
    public Object getParameter(String key) {
        return this.parameters.get(key);
    }

    @Override
    public String getMethodCallSyntax(String obj, String m, String ... args) {
        return String.format("%s.%s(%s)", obj, m, String.join((CharSequence)", ", args));
    }

    @Override
    public String getOutputStatement(String toDisplay) {
        return "print(" + toDisplay + ")";
    }

    @Override
    public String getProgram(String ... statements) {
        return String.join((CharSequence)"\n", statements);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScriptEngine getScriptEngine() {
        if (this.scriptEngine == null) {
            ScriptEngineFactoryImpl scriptEngineFactoryImpl = this;
            synchronized (scriptEngineFactoryImpl) {
                if (this.scriptEngine == null) {
                    this.scriptEngine = new ScriptEngineImpl(this);
                }
            }
        }
        return this.scriptEngine;
    }
}

