/*
 * Decompiled with CFR 0.152.
 */
package org.jpy;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.jpy.PyObject;

public class PyListWrapper
implements List<PyObject> {
    private PyObject pyObject;

    PyListWrapper(PyObject pyObject) {
        this.pyObject = pyObject;
    }

    @Override
    public int size() {
        try (PyObject len = this.pyObject.callMethod("__len__", new Object[0]);){
            int n = len.getIntValue();
            return n;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        for (PyObject obj : this) {
            if (!obj.equals(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<PyObject> iterator() {
        return new Iterator<PyObject>(){
            int ii = 0;
            int size = PyListWrapper.this.size();

            @Override
            public boolean hasNext() {
                return this.ii < this.size;
            }

            @Override
            public PyObject next() {
                return PyListWrapper.this.get(this.ii++);
            }
        };
    }

    public PyObject[] toArray() {
        int size = this.size();
        PyObject[] result = new PyObject[size];
        for (int ii = 0; ii < size; ++ii) {
            result[ii] = this.get(ii);
        }
        return result;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int size = this.size();
        if (a.length < size) {
            a = Arrays.copyOf(a, size);
        }
        for (int ii = 0; ii < size; ++ii) {
            a[ii] = this.get(ii);
        }
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    @Override
    public boolean add(PyObject pyObject) {
        PyObject obj = pyObject.callMethod("append", pyObject);
        Throwable throwable = null;
        if (obj != null) {
            if (throwable != null) {
                try {
                    obj.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                obj.close();
            }
        }
        return true;
    }

    @Override
    public boolean remove(Object o) {
        try {
            PyObject obj = this.pyObject.callMethod("remove", o);
            Throwable throwable = null;
            if (obj != null) {
                if (throwable != null) {
                    try {
                        obj.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    obj.close();
                }
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return c.stream().allMatch(this::contains);
    }

    @Override
    public boolean addAll(Collection<? extends PyObject> c) {
        boolean result = false;
        for (PyObject pyObject : c) {
            result |= this.add(pyObject);
        }
        return result;
    }

    @Override
    public boolean addAll(int index, Collection<? extends PyObject> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        PyObject obj = this.pyObject.callMethod("clear", new Object[0]);
        Throwable throwable = null;
        if (obj != null) {
            if (throwable != null) {
                try {
                    obj.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                obj.close();
            }
        }
    }

    @Override
    public PyObject get(int index) {
        return this.pyObject.callMethod("__getitem__", index);
    }

    @Override
    public PyObject set(int index, PyObject element) {
        PyObject existing = this.get(index);
        this.setItem(index, element);
        return existing;
    }

    public void setItem(int index, PyObject element) {
        PyObject obj = this.pyObject.callMethod("__setitem__", index, element);
        Throwable throwable = null;
        if (obj != null) {
            if (throwable != null) {
                try {
                    obj.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                obj.close();
            }
        }
    }

    @Override
    public void add(int index, PyObject element) {
        PyObject obj = this.pyObject.callMethod("insert", index, element);
        Throwable throwable = null;
        if (obj != null) {
            if (throwable != null) {
                try {
                    obj.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                obj.close();
            }
        }
    }

    @Override
    public PyObject remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object o) {
        int size = this.size();
        for (int ii = 0; ii < size; ++ii) {
            PyObject pyObject = this.get(ii);
            if (!(pyObject == null ? o == null : pyObject.equals(o))) continue;
            return ii;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        int size = this.size();
        for (int ii = size - 1; ii >= 0; --ii) {
            PyObject pyObject = this.get(ii);
            if (!(pyObject == null ? o == null : pyObject.equals(o))) continue;
            return ii;
        }
        return -1;
    }

    @Override
    public ListIterator<PyObject> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<PyObject> listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<PyObject> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    public String toString(int prefixLength) {
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuilder builder = new StringBuilder("[");
        int displaySize = Math.min(this.size(), prefixLength);
        builder.append(this.get(0).str());
        for (int ei = 1; ei < displaySize; ++ei) {
            builder.append(", ").append(this.get(ei).str());
        }
        if (displaySize == this.size()) {
            builder.append(']');
        } else {
            builder.append(", ...]");
        }
        return builder.toString();
    }
}

