/*
 * Decompiled with CFR 0.152.
 */
package org.jpy;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Properties;
import java.util.Set;

class PyLibConfig {
    private static final boolean DEBUG;
    public static final String PYTHON_LIB_KEY = "jpy.pythonLib";
    public static final String JPY_LIB_KEY = "jpy.jpyLib";
    public static final String JDL_LIB_KEY = "jpy.jdlLib";
    public static final String JPY_CONFIG_KEY = "jpy.config";
    public static final String JPY_CONFIG_RESOURCE = "jpyconfig.properties";
    private static final Properties properties;

    PyLibConfig() {
    }

    private static void loadConfig(InputStream stream, String name) {
        block15: {
            try {
                if (DEBUG) {
                    System.out.printf(String.format("org.jpy.PyLibConfig: loading configuration resource %s\n", name), new Object[0]);
                }
                try (InputStreamReader reader = new InputStreamReader(stream);){
                    PyLibConfig.loadConfig(reader);
                }
            }
            catch (IOException e) {
                if (!DEBUG) break block15;
                e.printStackTrace(System.err);
            }
        }
    }

    private static void loadConfig(File file) {
        block15: {
            try {
                if (DEBUG) {
                    System.out.printf(String.format("%s: loading configuration file %s\n", PyLibConfig.class.getName(), file), new Object[0]);
                }
                try (FileReader reader = new FileReader(file);){
                    PyLibConfig.loadConfig(reader);
                }
            }
            catch (IOException e) {
                System.err.printf("org.jpy.PyLibConfig: %s: %s\n", file, e.getMessage());
                if (!DEBUG) break block15;
                e.printStackTrace(System.err);
            }
        }
    }

    private static void loadConfig(Reader reader) throws IOException {
        properties.load(reader);
        Set<String> propertyNames = properties.stringPropertyNames();
        for (String propertyName : propertyNames) {
            String propertyValue = properties.getProperty(propertyName);
            if (propertyValue == null) continue;
            System.setProperty(propertyName, propertyValue);
        }
    }

    public static Properties getProperties() {
        return new Properties(properties);
    }

    public static String getProperty(String key, boolean mustHave) {
        String property = System.getProperty(key);
        if (property != null) {
            return property;
        }
        property = properties.getProperty(key);
        if (property == null && mustHave) {
            throw new RuntimeException("missing configuration property '" + key + "'");
        }
        return property;
    }

    public static OS getOS() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("win")) {
            return OS.WINDOWS;
        }
        if (os.contains("nix") || os.contains("nux") || os.contains("aix")) {
            return OS.UNIX;
        }
        if (os.contains("mac")) {
            return OS.MAC_OS;
        }
        if (os.contains("sunos")) {
            return OS.SUNOS;
        }
        return null;
    }

    static {
        File file;
        String path;
        InputStream stream;
        DEBUG = Boolean.getBoolean("jpy.debug");
        properties = new Properties();
        if (DEBUG) {
            System.out.println("org.jpy.PyLibConfig: entered static initializer");
        }
        if ((stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(JPY_CONFIG_RESOURCE)) != null) {
            PyLibConfig.loadConfig(stream, JPY_CONFIG_RESOURCE);
        }
        if ((path = System.getProperty(JPY_CONFIG_KEY)) != null && (file = new File(path)).isFile()) {
            PyLibConfig.loadConfig(file);
        }
        if ((file = new File(JPY_CONFIG_RESOURCE).getAbsoluteFile()).isFile()) {
            PyLibConfig.loadConfig(file);
        }
        if (DEBUG) {
            System.out.println("org.jpy.PyLibConfig: exited static initializer");
        }
    }

    public static enum OS {
        WINDOWS,
        UNIX,
        MAC_OS,
        SUNOS;

    }
}

