/*
 * Decompiled with CFR 0.152.
 */
package org.jpy;

import java.util.Objects;
import org.jpy.PyLib;
import org.jpy.PyObject;

public class PyModule
extends PyObject {
    private final String name;

    PyModule(String name, long pointer) {
        super(pointer);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static PyModule getMain() {
        return PyModule.importModule("__main__");
    }

    public static PyModule getBuiltins() {
        try {
            return PyModule.importModule("builtins");
        }
        catch (Exception e) {
            return PyModule.importModule("__builtin__");
        }
    }

    public static PyModule importModule(String name) {
        PyLib.assertPythonRuns();
        Objects.requireNonNull(name, "name must not be null");
        long pointer = PyLib.importModule(name);
        return pointer != 0L ? new PyModule(name, pointer) : null;
    }

    public static PyObject extendSysPath(String modulePath, boolean prepend) {
        Objects.requireNonNull(modulePath, "path must not be null");
        try (PyModule sys = PyModule.importModule("sys");){
            Throwable throwable;
            PyObject pyObj;
            PyObject sysPath = sys.getAttribute("path");
            if (prepend) {
                pyObj = sysPath.call("insert", 0, modulePath);
                throwable = null;
                if (pyObj != null) {
                    if (throwable != null) {
                        try {
                            pyObj.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    } else {
                        pyObj.close();
                    }
                }
            } else {
                pyObj = sysPath.call("append", modulePath);
                throwable = null;
                if (pyObj != null) {
                    if (throwable != null) {
                        try {
                            pyObj.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        pyObj.close();
                    }
                }
            }
            PyObject pyObject = sysPath;
            return pyObject;
        }
    }

    @Override
    public <T> T createProxy(Class<T> type) {
        PyLib.assertPythonRuns();
        Objects.requireNonNull(type, "type must not be null");
        return (T)this.createProxy(PyLib.CallableKind.FUNCTION, type);
    }
}

