/*
 * Decompiled with CFR 0.152.
 */
package org.jpy;

import java.io.FileNotFoundException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.jpy.Assignment;
import org.jpy.PyDictWrapper;
import org.jpy.PyInputMode;
import org.jpy.PyLib;
import org.jpy.PyListWrapper;
import org.jpy.PyObjectReferences;
import org.jpy.PyObjectState;
import org.jpy.PyProxyHandler;

public class PyObject
implements AutoCloseable {
    private static final PyObjectReferences REFERENCES = new PyObjectReferences();
    private static final AtomicReference<Thread> CLEANUP_THREAD = new AtomicReference();
    private static final boolean CLEANUP_ON_INIT = Boolean.parseBoolean(System.getProperty("PyObject.cleanup_on_init", "true"));
    private static final boolean CLEANUP_ON_THREAD = Boolean.parseBoolean(System.getProperty("PyObject.cleanup_on_thread", "true"));
    private final PyObjectState state;

    private static void startCleanupThread() {
        if (CLEANUP_THREAD.get() == null) {
            Thread thread = REFERENCES.createCleanupThread("PyObject-cleanup");
            thread.setDaemon(true);
            if (!CLEANUP_THREAD.compareAndSet(null, thread)) {
                return;
            }
            thread.start();
        }
    }

    public static int cleanup() {
        return REFERENCES.asProxy().cleanupOnlyUseFromGIL();
    }

    PyObject(long pointer) {
        this(pointer, false);
    }

    PyObject(long pointer, boolean fromJNI) {
        this.state = new PyObjectState(pointer);
        if (fromJNI) {
            if (CLEANUP_ON_INIT && PyLib.hasGil()) {
                REFERENCES.cleanupOnlyUseFromGIL();
            }
            if (CLEANUP_ON_THREAD) {
                PyObject.startCleanupThread();
            }
        }
        this.registerSelfInto(REFERENCES);
    }

    final void registerSelfInto(PyObjectReferences references) {
        references.register(this);
    }

    final PyObjectState getState() {
        return this.state;
    }

    @Override
    public final void close() {
        this.state.close();
    }

    public static PyObject executeCode(String code, PyInputMode mode) {
        return PyObject.executeCode(code, mode, null, null);
    }

    public static PyObject executeScript(String script, PyInputMode mode) throws FileNotFoundException {
        return PyObject.executeScript(script, mode, null, null);
    }

    public static PyObject executeCode(String code, PyInputMode mode, Object globals, Object locals) {
        Objects.requireNonNull(code, "code must not be null");
        Objects.requireNonNull(mode, "mode must not be null");
        return new PyObject(PyLib.executeCode(code, mode.value(), globals, locals));
    }

    public static PyObject executeScript(String script, PyInputMode mode, Object globals, Object locals) throws FileNotFoundException {
        Objects.requireNonNull(script, "script must not be null");
        Objects.requireNonNull(mode, "mode must not be null");
        return new PyObject(PyLib.executeScript(script, mode.value(), globals, locals));
    }

    public final long getPointer() {
        return this.state.borrowPointer();
    }

    public int getIntValue() {
        PyLib.assertPythonRuns();
        return PyLib.getIntValue(this.getPointer());
    }

    public long getLongValue() {
        PyLib.assertPythonRuns();
        return PyLib.getLongValue(this.getPointer());
    }

    public boolean getBooleanValue() {
        PyLib.assertPythonRuns();
        return PyLib.getBooleanValue(this.getPointer());
    }

    public double getDoubleValue() {
        PyLib.assertPythonRuns();
        return PyLib.getDoubleValue(this.getPointer());
    }

    public String getStringValue() {
        PyLib.assertPythonRuns();
        return PyLib.getStringValue(this.getPointer());
    }

    public Object getObjectValue() {
        PyLib.assertPythonRuns();
        return PyLib.getObjectValue(this.getPointer());
    }

    public PyObject getType() {
        PyLib.assertPythonRuns();
        return new PyObject(PyLib.getType(this.getPointer()));
    }

    public boolean isDict() {
        PyLib.assertPythonRuns();
        return PyLib.pyDictCheck(this.getPointer());
    }

    public boolean isList() {
        PyLib.assertPythonRuns();
        return PyLib.pyListCheck(this.getPointer());
    }

    public boolean isBoolean() {
        PyLib.assertPythonRuns();
        return PyLib.pyBoolCheck(this.getPointer());
    }

    public boolean isLong() {
        PyLib.assertPythonRuns();
        return PyLib.pyLongCheck(this.getPointer());
    }

    public boolean isInt() {
        PyLib.assertPythonRuns();
        return PyLib.pyIntCheck(this.getPointer());
    }

    public boolean isNone() {
        PyLib.assertPythonRuns();
        return PyLib.pyNoneCheck(this.getPointer());
    }

    public boolean isFloat() {
        PyLib.assertPythonRuns();
        return PyLib.pyFloatCheck(this.getPointer());
    }

    public boolean isCallable() {
        PyLib.assertPythonRuns();
        return PyLib.pyCallableCheck(this.getPointer());
    }

    public boolean isFunction() {
        PyLib.assertPythonRuns();
        return PyLib.pyFunctionCheck(this.getPointer());
    }

    public boolean isModule() {
        PyLib.assertPythonRuns();
        return PyLib.pyModuleCheck(this.getPointer());
    }

    public boolean isTuple() {
        PyLib.assertPythonRuns();
        return PyLib.pyTupleCheck(this.getPointer());
    }

    public boolean isString() {
        PyLib.assertPythonRuns();
        return PyLib.pyStringCheck(this.getPointer());
    }

    public boolean isConvertible() {
        PyLib.assertPythonRuns();
        return PyLib.isConvertible(this.getPointer());
    }

    public List<PyObject> asList() {
        if (!this.isList()) {
            throw new ClassCastException("Can not convert non-list type to a list!");
        }
        return new PyListWrapper(this);
    }

    public PyDictWrapper asDict() {
        if (!this.isDict()) {
            throw new ClassCastException("Can not convert non-list type to a dictionary!");
        }
        return new PyDictWrapper(this);
    }

    public <T> T[] getObjectArrayValue(Class<? extends T> itemType) {
        PyLib.assertPythonRuns();
        Objects.requireNonNull(itemType, "itemType must not be null");
        return PyLib.getObjectArrayValue(this.getPointer(), itemType);
    }

    public PyObject getAttribute(String name) {
        PyLib.assertPythonRuns();
        Objects.requireNonNull(name, "name must not be null");
        long pointer = PyLib.getAttributeObject(this.getPointer(), name);
        return pointer != 0L ? new PyObject(pointer) : null;
    }

    public <T> T getAttribute(String name, Class<? extends T> valueType) {
        PyLib.assertPythonRuns();
        Objects.requireNonNull(name, "name must not be null");
        return PyLib.getAttributeValue(this.getPointer(), name, valueType);
    }

    public <T> void setAttribute(String name, T value) {
        PyLib.assertPythonRuns();
        Objects.requireNonNull(name, "name must not be null");
        PyLib.setAttributeValue(this.getPointer(), name, value, value != null ? value.getClass() : null);
    }

    public void delAttribute(String name) {
        PyLib.assertPythonRuns();
        Objects.requireNonNull(name, "name must not be null");
        PyLib.delAttribute(this.getPointer(), name);
    }

    public boolean hasAttribute(String name) {
        PyLib.assertPythonRuns();
        Objects.requireNonNull(name, "name must not be null");
        return PyLib.hasAttribute(this.getPointer(), name);
    }

    public <T> void setAttribute(String name, T value, Class<? extends T> valueType) {
        PyLib.assertPythonRuns();
        Objects.requireNonNull(name, "name must not be null");
        PyLib.setAttributeValue(this.getPointer(), name, value, valueType);
    }

    public PyObject callMethod(String name, Object ... args) {
        PyLib.assertPythonRuns();
        Objects.requireNonNull(name, "name must not be null");
        long pointer = PyLib.callAndReturnObject(this.getPointer(), true, name, args.length, args, null);
        return pointer != 0L ? new PyObject(pointer) : null;
    }

    public PyObject call(String name, Object ... args) {
        PyLib.assertPythonRuns();
        Objects.requireNonNull(name, "name must not be null");
        long pointer = PyLib.callAndReturnObject(this.getPointer(), false, name, args.length, args, null);
        return pointer != 0L ? new PyObject(pointer) : null;
    }

    public <T> T call(Class<T> returnType, String name, Class<?>[] paramTypes, Object[] args) {
        Objects.requireNonNull(returnType, "returnType must not be null");
        Objects.requireNonNull(name, "name must not be null");
        Objects.requireNonNull(paramTypes, "paramTypes must not be null");
        Objects.requireNonNull(args, "args must not be null");
        if (paramTypes.length != args.length) {
            throw new IllegalArgumentException("paramTypes and args must be of equal length");
        }
        for (int i = 0; i < args.length; ++i) {
            Objects.requireNonNull(paramTypes[i], "paramTypes items must be non null");
            Objects.requireNonNull(args[i], "args items must be non null");
            if (Assignment.isAssignableFrom(paramTypes[i], args[i])) continue;
            throw new IllegalArgumentException(String.format("Argument %d of type '%s' is not assignable to type '%s'", i, args[i].getClass(), paramTypes[i]));
        }
        PyLib.assertPythonRuns();
        return PyLib.callAndReturnValue(this.getPointer(), false, name, args.length, args, paramTypes, returnType);
    }

    public <T, A0> T call(Class<T> returnType, String name, Class<A0> clazz0, A0 arg0) {
        return this.call(returnType, name, new Class[]{clazz0}, new Object[]{arg0});
    }

    public <T, A0, A1> T call(Class<T> returnType, String name, Class<A0> clazz0, A0 arg0, Class<A1> clazz1, A1 arg1) {
        return this.call(returnType, name, new Class[]{clazz0, clazz1}, new Object[]{arg0, arg1});
    }

    public <T, A0, A1, A2> T call(Class<T> returnType, String name, Class<A0> clazz0, A0 arg0, Class<A1> clazz1, A1 arg1, Class<A2> clazz2, A2 arg2) {
        return this.call(returnType, name, new Class[]{clazz0, clazz1, clazz2}, new Object[]{arg0, arg1, arg2});
    }

    public <T> T createProxy(Class<T> type) {
        PyLib.assertPythonRuns();
        Objects.requireNonNull(type, "type must not be null");
        return (T)this.createProxy(PyLib.CallableKind.METHOD, type);
    }

    public Object createProxy(PyLib.CallableKind callableKind, Class<?> ... types) {
        PyLib.assertPythonRuns();
        ClassLoader classLoader = types[0].getClassLoader();
        PyProxyHandler invocationHandler = new PyProxyHandler(this, callableKind);
        return Proxy.newProxyInstance(classLoader, types, (InvocationHandler)invocationHandler);
    }

    public static PyObject unwrapProxy(Object object) {
        if (!Proxy.isProxyClass(object.getClass())) {
            return null;
        }
        InvocationHandler handler = Proxy.getInvocationHandler(object);
        if (!(handler instanceof PyProxyHandler)) {
            return null;
        }
        return ((PyProxyHandler)handler).getPyObject();
    }

    public final String toString() {
        return this.str();
    }

    public final String repr() {
        return PyLib.repr(this.getPointer());
    }

    public final String str() {
        return PyLib.str(this.getPointer());
    }

    public final long hash() {
        return PyLib.hash(this.getPointer());
    }

    public final boolean eq(Object other) {
        return PyLib.eq(this.getPointer(), other);
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PyObject)) {
            return false;
        }
        PyObject pyObject = (PyObject)o;
        return this.getPointer() == pyObject.getPointer();
    }

    public final int hashCode() {
        long pointer = this.getPointer();
        return (int)(pointer ^ pointer >>> 32);
    }
}

