/*
 * Decompiled with CFR 0.152.
 */
package org.jpy;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jpy.PyLib;
import org.jpy.PyObject;
import org.jpy.PyObjectCleanup;
import org.jpy.PyObjectState;

class PyObjectReferences {
    private static final String WEAK = "weak";
    private static final String REF_TYPE = System.getProperty("PyObject.reference_type", "weak");
    private static final int DEFAULT_BATCH_CLOSE_SIZE = Integer.parseInt(System.getProperty("PyObject.batch_close_size", "4096"));
    private static final long CLEANUP_THREAD_ACTIVE_SLEEP_MILLIS = Long.parseLong(System.getProperty("PyObject.active_sleep_millis", "0"));
    private static final long CLEANUP_THREAD_PASSIVE_SLEEP_MILLIS = Long.parseLong(System.getProperty("PyObject.passive_sleep_millis", "1000"));
    private final ReferenceQueue<PyObject> referenceQueue;
    private final Map<Reference<PyObject>, PyObjectState> references;
    private final long[] buffer;

    PyObjectReferences() {
        this(DEFAULT_BATCH_CLOSE_SIZE);
    }

    PyObjectReferences(int batchCloseSize) {
        if (batchCloseSize <= 0) {
            throw new IllegalArgumentException("batchCloseSize must be positive");
        }
        this.referenceQueue = new ReferenceQueue();
        this.references = new ConcurrentHashMap<Reference<PyObject>, PyObjectState>();
        this.buffer = new long[batchCloseSize];
    }

    void register(PyObject pyObject) {
        if (this.references.put(this.asRef(pyObject), pyObject.getState()) != null) {
            throw new IllegalStateException("Existing reference overwritten - this should not happen.");
        }
    }

    private Reference<PyObject> asRef(PyObject pyObject) {
        return WEAK.equals(REF_TYPE) ? new WeakReference<PyObject>(pyObject, this.referenceQueue) : new PhantomReference<PyObject>(pyObject, this.referenceQueue);
    }

    public int cleanupOnlyUseFromGIL() {
        return this.cleanupOnlyUseFromGIL(this.buffer);
    }

    private int cleanupOnlyUseFromGIL(long[] buffer) {
        return PyLib.ensureGil(() -> {
            Reference<PyObject> reference;
            int index = 0;
            while (index < buffer.length && (reference = this.referenceQueue.poll()) != null) {
                index = this.appendIfNotClosed(buffer, index, reference);
            }
            if (index == 0) {
                return 0;
            }
            if (index == 1) {
                PyLib.decRef(buffer[0]);
                return 1;
            }
            PyLib.decRefs(buffer, index);
            return index;
        });
    }

    private int appendIfNotClosed(long[] buffer, int index, Reference<? extends PyObject> reference) {
        reference.clear();
        PyObjectState state = this.references.remove(reference);
        if (state == null) {
            throw new IllegalStateException("Reference from queue not in map - this should not happen.");
        }
        long pointerForClosure = state.takePointer();
        if (pointerForClosure == 0L) {
            return index;
        }
        buffer[index] = pointerForClosure;
        return index + 1;
    }

    /*
     * Exception decompiling
     */
    PyObjectCleanup asProxy() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    Thread createCleanupThread(String name) {
        return new Thread(this::cleanupThreadLogic, name);
    }

    private void cleanupThreadLogic() {
        PyObjectCleanup proxy = this.asProxy();
        while (!Thread.currentThread().isInterrupted()) {
            int size = proxy.cleanupOnlyUseFromGIL();
            if (size == this.buffer.length) {
                if (CLEANUP_THREAD_ACTIVE_SLEEP_MILLIS == 0L) {
                    Thread.yield();
                    continue;
                }
                try {
                    Thread.sleep(CLEANUP_THREAD_ACTIVE_SLEEP_MILLIS);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            try {
                Thread.sleep(CLEANUP_THREAD_PASSIVE_SLEEP_MILLIS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }
}

