/*
 * Decompiled with CFR 0.152.
 */
package org.jpy;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.jpy.PyLib;
import org.jpy.PyObject;

class PyProxyHandler
implements InvocationHandler {
    private static Method hashCodeMethod;
    private static Method equalsMethod;
    private static Method toStringMethod;
    private final PyObject pyObject;
    private final PyLib.CallableKind callableKind;

    public PyProxyHandler(PyObject pyObject, PyLib.CallableKind callableKind) {
        if (pyObject == null) {
            throw new NullPointerException("pyObject");
        }
        this.pyObject = pyObject;
        this.callableKind = callableKind;
    }

    @Override
    public Object invoke(Object proxyObject, Method method, Object[] args) throws Throwable {
        if (method.isDefault()) {
            Class<?> declaringClass = method.getDeclaringClass();
            Constructor constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class);
            constructor.setAccessible(true);
            return ((MethodHandles.Lookup)constructor.newInstance(declaringClass)).in(declaringClass).unreflectSpecial(method, declaringClass).bindTo(proxyObject).invokeWithArguments(args);
        }
        long pointer = this.pyObject.getPointer();
        if ((PyLib.Diag.getFlags() & 2) != 0) {
            System.out.printf("org.jpy.PyProxyHandler: invoke: %s(%s) on pyObject=%s in thread %s\n", method.getName(), Arrays.toString(args), Long.toHexString(pointer), Thread.currentThread());
        }
        String methodName = method.getName();
        Class<?> returnType = method.getReturnType();
        if (method.equals(hashCodeMethod)) {
            return this.callPythonHash();
        }
        if (method.equals(equalsMethod)) {
            return this.pyObject.eq(args[0]);
        }
        if (method.equals(toStringMethod)) {
            return this.pyObject.str();
        }
        if ("close".equals(method.getName()) && method.getParameterCount() == 0 && Void.TYPE.equals(method.getReturnType()) && AutoCloseable.class.isAssignableFrom(method.getDeclaringClass())) {
            this.pyObject.close();
            return null;
        }
        return PyLib.callAndReturnValue(pointer, this.callableKind == PyLib.CallableKind.METHOD, methodName, args != null ? args.length : 0, args, method.getParameterTypes(), returnType);
    }

    PyObject getPyObject() {
        return this.pyObject;
    }

    private int callPythonHash() {
        return Long.hashCode(this.pyObject.hash());
    }

    static {
        try {
            hashCodeMethod = Object.class.getMethod("hashCode", new Class[0]);
            equalsMethod = Object.class.getMethod("equals", Object.class);
            toStringMethod = Object.class.getMethod("toString", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodError(e.getMessage());
        }
    }
}

