/*
 * Decompiled with CFR 0.152.
 */
package org.jqassistant.plugin.m2repo.impl.scanner;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.jqassistant.plugin.m2repo.api.ArtifactProvider;
import org.jqassistant.plugin.m2repo.impl.scanner.MavenIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AetherArtifactProvider
implements ArtifactProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(AetherArtifactProvider.class);
    private final URL url;
    private final String username;
    private final String password;
    private final File repositoryRoot;
    private final RemoteRepository repository;
    private final RepositorySystem repositorySystem;
    private final DefaultRepositorySystemSession session;

    public AetherArtifactProvider(URL repositoryUrl, File workDirectory) {
        this.url = repositoryUrl;
        String userInfo = repositoryUrl.getUserInfo();
        this.username = StringUtils.substringBefore((String)userInfo, (String)":");
        this.password = StringUtils.substringAfter((String)userInfo, (String)":");
        AuthenticationBuilder authBuilder = new AuthenticationBuilder();
        if (this.username != null) {
            authBuilder.addUsername(this.username);
        }
        if (this.password != null) {
            authBuilder.addPassword(this.password);
        }
        String repositoryId = this.getRepositoryId(repositoryUrl);
        String url = StringUtils.replace((String)repositoryUrl.toString(), (String)(repositoryUrl.getUserInfo() + "@"), (String)"");
        Authentication auth = authBuilder.build();
        RepositoryPolicy repositoryPolicy = new RepositoryPolicy(true, "daily", "ignore");
        this.repository = new RemoteRepository.Builder(repositoryId, "default", url).setAuthentication(auth).setPolicy(repositoryPolicy).build();
        this.repositorySystem = this.newRepositorySystem();
        this.repositoryRoot = new File(workDirectory, repositoryId).getAbsoluteFile();
        LOGGER.info("Using local repository '{}' for URL '{}'", (Object)this.repositoryRoot.getAbsolutePath(), (Object)url);
        this.session = this.newRepositorySystemSession(this.repositorySystem, this.repositoryRoot);
    }

    private String getRepositoryId(URL repositoryUrl) {
        String host = repositoryUrl.getHost();
        int port = repositoryUrl.getPort();
        String path = repositoryUrl.getPath();
        StringBuilder repositoryIdBuilder = new StringBuilder(host);
        if (port != -1) {
            repositoryIdBuilder.append('/').append(port);
        }
        repositoryIdBuilder.append(path);
        return repositoryIdBuilder.toString();
    }

    @Override
    public ArtifactResult getArtifact(Artifact artifact) throws ArtifactResolutionException {
        ArtifactRequest artifactRequest = this.createArtifactRequest(artifact);
        return this.repositorySystem.resolveArtifact((RepositorySystemSession)this.session, artifactRequest);
    }

    @Override
    public File getRepositoryRoot() {
        return this.repositoryRoot;
    }

    public MavenIndex getMavenIndex() throws IOException {
        File indexRoot = new File(this.repositoryRoot, ".index");
        return new MavenIndex(this.url, indexRoot, indexRoot, this.username, this.password);
    }

    private ArtifactRequest createArtifactRequest(Artifact artifact) {
        ArtifactRequest artifactRequest = new ArtifactRequest();
        artifactRequest.setArtifact(artifact);
        List<RemoteRepository> repositories = Collections.singletonList(this.repository);
        artifactRequest.setRepositories(repositories);
        return artifactRequest;
    }

    private RepositorySystem newRepositorySystem() {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        return (RepositorySystem)locator.getService(RepositorySystem.class);
    }

    private DefaultRepositorySystemSession newRepositorySystemSession(RepositorySystem system, File localDirectory) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        LocalRepository localRepo = new LocalRepository(localDirectory);
        session.setLocalRepositoryManager(system.newLocalRepositoryManager((RepositorySystemSession)session, localRepo));
        return session;
    }
}

