/*
 * Decompiled with CFR 0.152.
 */
package org.jqassistant.plugin.m2repo.impl.scanner;

import com.buschmais.jqassistant.plugin.maven3.api.artifact.ArtifactFilter;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.index.ArtifactInfo;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.jqassistant.plugin.m2repo.api.ArtifactProvider;
import org.jqassistant.plugin.m2repo.impl.scanner.ArtifactSearchResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtifactTask
implements Callable<Void> {
    private static final String EXTENSION_POM = "pom";
    private static final Logger LOGGER = LoggerFactory.getLogger(ArtifactTask.class);
    private final ArtifactSearchResult artifactInfos;
    private final ArtifactFilter artifactFilter;
    private final boolean fetchArtifact;
    private final BlockingQueue<Result> queue;
    private final ArtifactProvider artifactProvider;

    ArtifactTask(ArtifactSearchResult artifactSearchResult, ArtifactFilter artifactFilter, boolean fetchArtifact, BlockingQueue<Result> queue, ArtifactProvider artifactProvider) {
        this.artifactInfos = artifactSearchResult;
        this.artifactFilter = artifactFilter;
        this.fetchArtifact = fetchArtifact;
        this.queue = queue;
        this.artifactProvider = artifactProvider;
    }

    @Override
    public Void call() {
        try {
            for (ArtifactInfo artifactInfo : this.artifactInfos) {
                Optional<Object> artifactResult;
                String version;
                String packaging;
                String classifier;
                String artifactId;
                String groupId = artifactInfo.getGroupId();
                DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId = artifactInfo.getArtifactId(), classifier = artifactInfo.getClassifier(), packaging = artifactInfo.getPackaging(), version = artifactInfo.getVersion());
                if (!this.artifactFilter.match(RepositoryUtils.toArtifact((Artifact)artifact))) {
                    LOGGER.debug("Skipping '{}'.", (Object)artifactInfo);
                    continue;
                }
                DefaultArtifact modelArtifact = new DefaultArtifact(groupId, artifactId, null, EXTENSION_POM, version);
                LOGGER.debug("Fetching model '{}'.", (Object)modelArtifact);
                Optional<ArtifactResult> modelArtifactResult = this.getArtifact((Artifact)modelArtifact);
                if (this.fetchArtifact && !artifact.getExtension().equals(EXTENSION_POM)) {
                    LOGGER.debug("Fetching artifact '{}'.", (Object)artifact);
                    artifactResult = this.getArtifact((Artifact)artifact);
                } else {
                    artifactResult = Optional.empty();
                }
                Result result = new Result(artifactInfo, modelArtifactResult, artifactResult);
                this.queue.put(result);
            }
            this.queue.put(Result.LAST);
        }
        catch (InterruptedException e) {
            LOGGER.warn("Task has been interrupted.", (Throwable)e);
        }
        return null;
    }

    private Optional<ArtifactResult> getArtifact(Artifact artifact) {
        try {
            return Optional.of(this.artifactProvider.getArtifact(artifact));
        }
        catch (ArtifactResolutionException e) {
            LOGGER.warn("Cannot resolve artifact '" + artifact + "'.", (Throwable)e);
            LOGGER.debug("Reason", (Throwable)e);
            return Optional.empty();
        }
    }

    public static class Result {
        public static final Result LAST = new Result(null, null, null);
        private final ArtifactInfo artifactInfo;
        private final Optional<ArtifactResult> modelArtifactResult;
        private final Optional<ArtifactResult> artifactResult;

        private Result(ArtifactInfo artifactInfo, Optional<ArtifactResult> modelArtifactResult, Optional<ArtifactResult> artifactResult) {
            this.artifactInfo = artifactInfo;
            this.modelArtifactResult = modelArtifactResult;
            this.artifactResult = artifactResult;
        }

        public ArtifactInfo getArtifactInfo() {
            return this.artifactInfo;
        }

        public Optional<ArtifactResult> getModelArtifactResult() {
            return this.modelArtifactResult;
        }

        public Optional<ArtifactResult> getArtifactResult() {
            return this.artifactResult;
        }
    }
}

