/*
 * Decompiled with CFR 0.152.
 */
package org.jqassistant.plugin.m2repo.impl.scanner;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import org.apache.lucene.search.Query;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.DefaultIndexer;
import org.apache.maven.index.DefaultIndexerEngine;
import org.apache.maven.index.DefaultQueryCreator;
import org.apache.maven.index.DefaultSearchEngine;
import org.apache.maven.index.Indexer;
import org.apache.maven.index.IndexerEngine;
import org.apache.maven.index.IteratorSearchRequest;
import org.apache.maven.index.IteratorSearchResponse;
import org.apache.maven.index.MAVEN;
import org.apache.maven.index.QueryCreator;
import org.apache.maven.index.SearchEngine;
import org.apache.maven.index.context.ExistingLuceneIndexMismatchException;
import org.apache.maven.index.context.IndexingContext;
import org.apache.maven.index.creator.JarFileContentsIndexCreator;
import org.apache.maven.index.creator.MavenArchetypeArtifactInfoIndexCreator;
import org.apache.maven.index.creator.MavenPluginArtifactInfoIndexCreator;
import org.apache.maven.index.creator.MinimalArtifactInfoIndexCreator;
import org.apache.maven.index.expr.SearchExpression;
import org.apache.maven.index.expr.SourcedSearchExpression;
import org.apache.maven.index.incremental.DefaultIncrementalHandler;
import org.apache.maven.index.incremental.IncrementalHandler;
import org.apache.maven.index.updater.DefaultIndexUpdater;
import org.apache.maven.index.updater.IndexUpdateRequest;
import org.apache.maven.index.updater.IndexUpdateResult;
import org.apache.maven.index.updater.ResourceFetcher;
import org.apache.maven.index.updater.WagonHelper;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.events.TransferEvent;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.observers.AbstractTransferListener;
import org.apache.maven.wagon.providers.http.HttpWagon;
import org.jqassistant.plugin.m2repo.impl.scanner.ArtifactSearchResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenIndex
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MavenIndex.class);
    private IndexingContext indexingContext;
    private Indexer indexer;
    private String password;
    private String username;

    public MavenIndex(URL repoUrl, File repositoryDirectory, File indexDirectory, String username, String password) throws IOException {
        this.username = username;
        this.password = password;
        try {
            this.createIndexingContext(repoUrl, repositoryDirectory, indexDirectory);
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e);
        }
    }

    private void createIndexingContext(URL repoUrl, File repositoryDirectory, File indexDirectory) throws ExistingLuceneIndexMismatchException, IllegalArgumentException, IOException {
        DefaultSearchEngine searchEngine = new DefaultSearchEngine();
        DefaultIndexerEngine indexerEngine = new DefaultIndexerEngine();
        DefaultQueryCreator queryCreator = new DefaultQueryCreator();
        this.indexer = new DefaultIndexer((SearchEngine)searchEngine, (IndexerEngine)indexerEngine, (QueryCreator)queryCreator);
        String repoSuffix = repoUrl.getHost();
        File localIndexDir = new File(indexDirectory, "repo-index");
        ArrayList<Object> indexers = new ArrayList<Object>();
        indexers.add(new MinimalArtifactInfoIndexCreator());
        indexers.add(new JarFileContentsIndexCreator());
        indexers.add(new MavenPluginArtifactInfoIndexCreator());
        indexers.add(new MavenArchetypeArtifactInfoIndexCreator());
        this.indexingContext = this.indexer.createIndexingContext("jqa-cxt-" + repoSuffix, "jqa-repo-id-" + repoSuffix, repositoryDirectory, localIndexDir, repoUrl.toString(), null, true, true, indexers);
    }

    @Override
    public void close() throws IOException {
        this.indexer.closeIndexingContext(this.indexingContext, false);
    }

    public ArtifactSearchResult getArtifactsSince(Date startDate) throws IOException {
        LOGGER.info("Executing query for artifacts that have been updated since {}.", (Object)startDate);
        long startDateMillis = startDate.getTime();
        Query query = this.indexer.constructQuery(MAVEN.GROUP_ID, (SearchExpression)new SourcedSearchExpression("N/P"));
        IteratorSearchRequest request = new IteratorSearchRequest(query, Collections.singletonList(this.indexingContext), (ctx, ai) -> startDateMillis < ai.getLastModified());
        IteratorSearchResponse artifactInfos = this.indexer.searchIterator(request);
        LOGGER.info("Artifact query returned {} hits (total).", (Object)artifactInfos.getTotalHitsCount());
        return new ArtifactSearchResult((Iterable<ArtifactInfo>)artifactInfos, artifactInfos.getTotalHitsCount());
    }

    public void updateIndex() throws IOException {
        if (this.indexingContext.getTimestamp() != null) {
            LOGGER.info("Current Maven index timestamp: {}", (Object)this.indexingContext.getTimestamp());
        }
        DefaultIncrementalHandler incrementalHandler = new DefaultIncrementalHandler();
        DefaultIndexUpdater indexUpdater = new DefaultIndexUpdater((IncrementalHandler)incrementalHandler, Collections.emptyList());
        HttpWagon httpWagon = new HttpWagon();
        AbstractTransferListener listener = new AbstractTransferListener(){

            public void transferStarted(TransferEvent transferEvent) {
                LOGGER.debug("Downloading " + transferEvent.getResource().getName());
            }

            public void transferProgress(TransferEvent transferEvent, byte[] buffer, int length) {
            }

            public void transferCompleted(TransferEvent transferEvent) {
                LOGGER.debug("Downloading " + transferEvent.getResource().getName() + " successful");
            }
        };
        AuthenticationInfo info = null;
        if (this.username != null && this.password != null) {
            info = new AuthenticationInfo();
            info.setUserName(this.username);
            info.setPassword(this.password);
        }
        LOGGER.info("Updating repository index, this may take a while...");
        WagonHelper.WagonFetcher resourceFetcher = new WagonHelper.WagonFetcher((Wagon)httpWagon, (TransferListener)listener, info, null);
        IndexUpdateRequest updateRequest = new IndexUpdateRequest(this.indexingContext, (ResourceFetcher)resourceFetcher);
        IndexUpdateResult updateResult = indexUpdater.fetchAndUpdateIndex(updateRequest);
        if (updateResult.isFullUpdate()) {
            LOGGER.info("Received a full update.");
        } else if (updateResult.getTimestamp() == null) {
            LOGGER.info("No update needed, index is up to date.");
        } else {
            LOGGER.info("Received an incremental update.");
        }
        LOGGER.info("Updated Maven index timestamp: {}", (Object)this.indexingContext.getTimestamp());
    }
}

