/*
 * Decompiled with CFR 0.152.
 */
package org.jqassistant.plugin.m2repo.impl.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractScannerPlugin;
import com.buschmais.jqassistant.plugin.common.api.scanner.FileResolver;
import com.buschmais.jqassistant.plugin.maven3.api.artifact.ArtifactFilter;
import com.buschmais.jqassistant.plugin.maven3.api.artifact.ArtifactResolver;
import com.buschmais.jqassistant.plugin.maven3.api.artifact.MavenRepositoryArtifactResolver;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenRepositoryDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.scanner.MavenRepositoryResolver;
import com.buschmais.jqassistant.plugin.maven3.api.scanner.MavenScope;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import org.jqassistant.plugin.m2repo.impl.scanner.AetherArtifactProvider;
import org.jqassistant.plugin.m2repo.impl.scanner.ArtifactSearchResult;
import org.jqassistant.plugin.m2repo.impl.scanner.ArtifactSearchResultScanner;
import org.jqassistant.plugin.m2repo.impl.scanner.MavenIndex;

public class MavenRepositoryScannerPlugin
extends AbstractScannerPlugin<URL, MavenRepositoryDescriptor> {
    private static final String PROPERTY_NAME_ARTIFACTS_KEEP = "m2repo.artifacts.keep";
    private static final String PROPERTY_NAME_ARTIFACTS_SCAN = "m2repo.artifacts.scan";
    private static final String PROPERTY_NAME_FILTER_INCLUDES = "m2repo.filter.includes";
    private static final String PROPERTY_NAME_FILTER_EXCLUDES = "m2repo.filter.excludes";
    private static final String PROPERTY_NAME_DIRECTORY = "m2repo.directory";
    private boolean keepArtifacts;
    private boolean scanArtifacts;
    private ArtifactFilter artifactFilter;
    private String localDirectoryName;

    public boolean accepts(URL item, String path, Scope scope) {
        return MavenScope.REPOSITORY == scope;
    }

    public void configure() {
        this.scanArtifacts = this.getBooleanProperty(PROPERTY_NAME_ARTIFACTS_SCAN, false);
        this.keepArtifacts = this.getBooleanProperty(PROPERTY_NAME_ARTIFACTS_KEEP, true);
        this.artifactFilter = new ArtifactFilter(this.getStringProperty(PROPERTY_NAME_FILTER_INCLUDES, null), this.getStringProperty(PROPERTY_NAME_FILTER_EXCLUDES, null));
        this.localDirectoryName = this.getStringProperty(PROPERTY_NAME_DIRECTORY, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MavenRepositoryDescriptor scan(URL repositoryUrl, String path, Scope scope, Scanner scanner) throws IOException {
        ScannerContext context = scanner.getContext();
        File localDirectory = this.getLocalDirectory(context);
        AetherArtifactProvider artifactProvider = new AetherArtifactProvider(repositoryUrl, localDirectory);
        ArtifactSearchResultScanner artifactSearchResultScanner = new ArtifactSearchResultScanner(scanner, artifactProvider, this.artifactFilter, this.scanArtifacts, this.keepArtifacts);
        MavenRepositoryDescriptor repositoryDescriptor = MavenRepositoryResolver.resolve((Store)context.getStore(), (String)repositoryUrl.toString());
        FileResolver fileResolver = (FileResolver)context.peek(FileResolver.class);
        MavenRepositoryArtifactResolver repositoryArtifactResolver = new MavenRepositoryArtifactResolver(artifactProvider.getRepositoryRoot(), fileResolver);
        try (MavenIndex mavenIndex = artifactProvider.getMavenIndex();){
            Date lastScanTime = new Date(repositoryDescriptor.getLastUpdate());
            mavenIndex.updateIndex();
            context.push(ArtifactResolver.class, (Object)repositoryArtifactResolver);
            try (ArtifactSearchResult searchResult = mavenIndex.getArtifactsSince(lastScanTime);){
                artifactSearchResultScanner.scan(searchResult, repositoryDescriptor);
            }
            finally {
                context.pop(ArtifactResolver.class);
            }
        }
        repositoryDescriptor.setLastUpdate(System.currentTimeMillis());
        return repositoryDescriptor;
    }

    private File getLocalDirectory(ScannerContext context) {
        File localDirectory;
        if (this.localDirectoryName != null) {
            localDirectory = new File(this.localDirectoryName);
            localDirectory.mkdirs();
        } else {
            localDirectory = context.getDataDirectory("m2repo");
        }
        return localDirectory;
    }
}

