/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.github;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.UpdateSection;
import org.jreleaser.model.releaser.spi.AbstractReleaser;
import org.jreleaser.model.releaser.spi.ReleaseException;
import org.jreleaser.model.releaser.spi.Repository;
import org.jreleaser.model.releaser.spi.User;
import org.jreleaser.sdk.git.GitSdk;
import org.jreleaser.sdk.git.ReleaseUtils;
import org.jreleaser.sdk.github.Github;
import org.jreleaser.sdk.github.XGithub;
import org.jreleaser.sdk.github.api.GhRelease;
import org.jreleaser.util.StringUtils;
import org.kohsuke.github.GHMilestone;
import org.kohsuke.github.GHRelease;
import org.kohsuke.github.GHReleaseUpdater;
import org.kohsuke.github.GHRepository;

public class GithubReleaser
extends AbstractReleaser {
    public GithubReleaser(JReleaserContext context, List<Path> assets) {
        super(context, assets);
    }

    protected void createTag() throws ReleaseException {
        ReleaseUtils.createTag((JReleaserContext)this.context);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void createRelease() throws ReleaseException {
        org.jreleaser.model.Github github = this.context.getModel().getRelease().getGithub();
        this.context.getLogger().info("Releasing to {}", new Object[]{github.getResolvedRepoUrl(this.context.getModel())});
        String tagName = github.getEffectiveTagName(this.context.getModel());
        try {
            String changelog = this.context.getChangelog();
            Github api = new Github(this.context.getLogger(), github.getResolvedToken(), github.getConnectTimeout(), github.getReadTimeout());
            this.context.getLogger().debug("looking up release with tag {} at repository {}", new Object[]{tagName, github.getCanonicalRepoName()});
            GHRelease release = api.findReleaseByTag(github.getCanonicalRepoName(), tagName);
            boolean snapshot = this.context.getModel().getProject().isSnapshot();
            if (null == release) {
                this.context.getLogger().debug("release {} does not exist", new Object[]{tagName});
                this.context.getLogger().debug("creating release {}", new Object[]{tagName});
                this.createRelease(api, tagName, changelog, snapshot);
                return;
            }
            this.context.getLogger().debug("release {} exists", new Object[]{tagName});
            if (github.isOverwrite() || snapshot) {
                this.context.getLogger().debug("deleting release {}", new Object[]{tagName});
                if (!this.context.isDryrun()) {
                    release.delete();
                }
                this.context.getLogger().debug("creating release {}", new Object[]{tagName});
                this.createRelease(api, tagName, changelog, true);
                return;
            }
            if (!github.isUpdate()) {
                if (!this.context.isDryrun()) throw new IllegalStateException("Github release failed because release " + tagName + " already exists. overwrite = false; update = false");
                this.context.getLogger().debug("creating release {}", new Object[]{tagName});
                this.createRelease(api, tagName, changelog, false);
                return;
            }
            this.context.getLogger().debug("updating release {}", new Object[]{tagName});
            if (this.context.isDryrun()) return;
            boolean update = false;
            GHReleaseUpdater updater = release.update();
            if (github.getUpdateSections().contains(UpdateSection.TITLE)) {
                update = true;
                this.context.getLogger().info("updating release title to {}", new Object[]{github.getEffectiveReleaseName()});
                updater.name(github.getEffectiveReleaseName());
            }
            if (github.getUpdateSections().contains(UpdateSection.BODY)) {
                update = true;
                this.context.getLogger().info("updating release body");
                updater.body(changelog);
            }
            if (update) {
                updater.update();
            }
            if (github.getUpdateSections().contains(UpdateSection.ASSETS)) {
                api.uploadAssets(release, this.assets);
            }
            this.linkDiscussion(tagName, release);
            return;
        }
        catch (IOException | IllegalStateException e) {
            this.context.getLogger().trace((Throwable)e);
            throw new ReleaseException((Throwable)e);
        }
    }

    public Repository maybeCreateRepository(String owner, String repo, String password) throws IOException {
        org.jreleaser.model.Github github = this.context.getModel().getRelease().getGithub();
        this.context.getLogger().debug("looking up {}/{}", new Object[]{owner, repo});
        Github api = new Github(this.context.getLogger(), github.getApiEndpoint(), password, github.getConnectTimeout(), github.getReadTimeout());
        GHRepository repository = api.findRepository(owner, repo);
        if (null == repository) {
            repository = api.createRepository(owner, repo);
        }
        return new Repository(Repository.Kind.GITHUB, owner, repo, repository.getUrl().toExternalForm(), repository.getHttpTransportUrl());
    }

    public Optional<User> findUser(String email, String name) {
        org.jreleaser.model.Github github = this.context.getModel().getRelease().getGithub();
        try {
            return new XGithub(this.context.getLogger(), github.getApiEndpoint(), github.getResolvedToken(), github.getConnectTimeout(), github.getReadTimeout()).findUser(email, name);
        }
        catch (IOException e) {
            this.context.getLogger().trace((Throwable)e);
            this.context.getLogger().debug("Could not find user matching {}", new Object[]{email});
            return Optional.empty();
        }
    }

    private void createRelease(Github api, String tagName, String changelog, boolean deleteTags) throws IOException {
        Optional<GHMilestone> milestone;
        org.jreleaser.model.Github github = this.context.getModel().getRelease().getGithub();
        if (this.context.isDryrun()) {
            for (Path asset : this.assets) {
                if (0L == asset.toFile().length() || !Files.exists(asset, new LinkOption[0])) continue;
                this.context.getLogger().info(" - uploading {}", new Object[]{asset.getFileName().toString()});
            }
            return;
        }
        if (deleteTags) {
            this.deleteTags(api, github.getCanonicalRepoName(), tagName);
        }
        if (deleteTags || !github.isSkipTag()) {
            this.context.getLogger().debug("tagging local repository with {}", new Object[]{tagName});
            GitSdk.of((JReleaserContext)this.context).tag(tagName, true, this.context);
        }
        GHRelease release = api.createRelease(github.getCanonicalRepoName(), tagName).commitish(github.getBranch()).name(github.getEffectiveReleaseName()).draft(github.isDraft()).prerelease(github.getPrerelease().isEnabled()).body(changelog).create();
        api.uploadAssets(release, this.assets);
        if (github.getMilestone().isClose().booleanValue() && !this.context.getModel().getProject().isSnapshot() && (milestone = api.findMilestoneByName(github.getOwner(), github.getName(), github.getMilestone().getEffectiveName())).isPresent()) {
            api.closeMilestone(github.getOwner(), github.getName(), milestone.get());
        }
        this.linkDiscussion(tagName, release);
    }

    private void linkDiscussion(String tagName, GHRelease release) {
        org.jreleaser.model.Github github = this.context.getModel().getRelease().getGithub();
        String discussionCategoryName = github.getDiscussionCategoryName();
        if (this.context.getModel().getProject().isSnapshot() || StringUtils.isBlank((String)discussionCategoryName) || github.isDraft()) {
            return;
        }
        this.context.getLogger().debug("linking release {} with discussion {}", new Object[]{tagName, discussionCategoryName});
        if (this.context.isDryrun()) {
            return;
        }
        try {
            XGithub xapi = new XGithub(this.context.getLogger(), github.getApiEndpoint(), github.getResolvedToken(), github.getConnectTimeout(), github.getReadTimeout());
            GhRelease ghRelease = new GhRelease();
            ghRelease.setDiscussionCategoryName(discussionCategoryName);
            xapi.updateRelease(github.getOwner(), github.getName(), tagName, release.getId(), ghRelease);
        }
        catch (IOException e) {
            this.context.getLogger().trace((Throwable)e);
            this.context.getLogger().warn("Could not update release {} with discussion category {}", new Object[]{tagName, discussionCategoryName});
        }
    }

    private void deleteTags(Github api, String repo, String tagName) {
        try {
            api.deleteTag(repo, tagName);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

