/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.assemblers;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.jreleaser.assemblers.AbstractAssemblerProcessor;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Glob;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.NativeImage;
import org.jreleaser.model.Project;
import org.jreleaser.model.assembler.spi.AssemblerProcessingException;
import org.jreleaser.util.FileUtils;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;
import org.jreleaser.util.Version;

public class NativeImageAssemblerProcessor
extends AbstractAssemblerProcessor<NativeImage> {
    private static final String KEY_JAVA_VERSION = "JAVA_VERSION";
    private static final String KEY_GRAALVM_VERSION = "GRAALVM_VERSION";

    public NativeImageAssemblerProcessor(JReleaserContext context) {
        super(context);
    }

    @Override
    protected void doAssemble(Map<String, Object> props) throws AssemblerProcessingException {
        Path graalPath = ((NativeImage)this.assembler).getGraal().getEffectivePath(this.context, this.assembler);
        Version javaVersion = Version.of((String)this.readJavaVersion(graalPath));
        Version graalVersion = Version.of((String)this.readGraalVersion(graalPath));
        this.context.getLogger().debug("java version is {}", new Object[]{javaVersion});
        this.context.getLogger().debug("graal version is {}", new Object[]{graalVersion});
        Path assembleDirectory = (Path)props.get("distributionAssembleDirectory");
        Path libDirectory = assembleDirectory.resolve("lib");
        this.context.getLogger().debug("copying JARs to {}", new Object[]{this.context.relativizeToBasedir(libDirectory)});
        Set<Path> jars = this.copyJars(this.context, libDirectory);
        this.installNativeImage(graalPath);
        Artifact image = this.nativeImage(assembleDirectory, graalPath, jars);
        if (StringUtils.isNotBlank((String)((NativeImage)this.assembler).getImageNameTransform())) {
            image.setTransform(((NativeImage)this.assembler).getResolvedImageNameTransform(this.context) + "-" + ((NativeImage)this.assembler).getGraal().getPlatform() + ".zip");
            image.getEffectivePath(this.context);
        }
    }

    private void installNativeImage(Path graalPath) throws AssemblerProcessingException {
        Path nativeImageExecutable = graalPath.resolve("bin").resolve(PlatformUtils.isWindows() ? "native-image.exe" : "native-image").toAbsolutePath();
        if (!Files.exists(nativeImageExecutable, new LinkOption[0])) {
            this.context.getLogger().debug("installing native-image executable");
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add(graalPath.resolve("bin").resolve("gu").toAbsolutePath().toString());
            cmd.add("install");
            cmd.add("native-image");
            this.executeCommand(cmd);
        }
    }

    private Artifact nativeImage(Path assembleDirectory, Path graalPath, Set<Path> jars) throws AssemblerProcessingException {
        String finalImageName = ((NativeImage)this.assembler).getResolvedImageName(this.context) + "-" + ((NativeImage)this.assembler).getGraal().getPlatform();
        String executable = ((NativeImage)this.assembler).getExecutable();
        this.context.getLogger().info("- {}", new Object[]{finalImageName});
        Path image = assembleDirectory.resolve(executable).toAbsolutePath();
        try {
            if (Files.exists(image, new LinkOption[0])) {
                Files.deleteIfExists(image);
            }
        }
        catch (IOException e) {
            throw new AssemblerProcessingException("Could not delete previous image " + executable, (Throwable)e);
        }
        ((NativeImage)this.assembler).getArgs().stream().filter(arg -> arg.startsWith("-H:Name")).findFirst().ifPresent(((NativeImage)this.assembler).getArgs()::remove);
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(graalPath.resolve("bin").resolve("native-image").toAbsolutePath().toString());
        cmd.addAll(((NativeImage)this.assembler).getArgs());
        cmd.add("-jar");
        cmd.add(((NativeImage)this.assembler).getMainJar().getEffectivePath(this.context).toAbsolutePath().toString());
        if (!jars.isEmpty()) {
            cmd.add("-cp");
            cmd.add(jars.stream().map(Path::getFileName).map(Path::toString).collect(Collectors.joining(File.pathSeparator)));
        }
        cmd.add("-H:Name=" + image.getFileName().toString());
        this.executeCommand(image.getParent(), cmd);
        try {
            Path tempDirectory = Files.createTempDirectory("jreleaser", new FileAttribute[0]);
            Path distDirectory = tempDirectory.resolve(finalImageName);
            Files.createDirectories(distDirectory, new FileAttribute[0]);
            Path binDirectory = distDirectory.resolve("bin");
            Files.createDirectories(binDirectory, new FileAttribute[0]);
            Files.copy(image, binDirectory.resolve(image.getFileName()), new CopyOption[0]);
            this.copyFiles(this.context, distDirectory);
            Path imageZip = assembleDirectory.resolve(finalImageName + ".zip");
            FileUtils.zip((Path)tempDirectory, (Path)imageZip);
            this.context.getLogger().debug("- {}", new Object[]{imageZip.getFileName()});
            return Artifact.of((Path)imageZip, (String)((NativeImage)this.assembler).getGraal().getPlatform());
        }
        catch (IOException e) {
            throw new AssemblerProcessingException("Unexpected error", (Throwable)e);
        }
    }

    private String readJavaVersion(Path path) throws AssemblerProcessingException {
        Path release = path.resolve("release");
        if (!Files.exists(release, new LinkOption[0])) {
            throw new AssemblerProcessingException("Invalid GraalVM [" + path.toAbsolutePath() + "] release file not found");
        }
        try {
            Properties props = new Properties();
            props.load(Files.newInputStream(release, new OpenOption[0]));
            if (props.containsKey(KEY_JAVA_VERSION)) {
                String version = props.getProperty(KEY_JAVA_VERSION);
                if (version.startsWith("\"") && version.endsWith("\"")) {
                    return version.substring(1, version.length() - 1);
                }
                return version;
            }
            throw new AssemblerProcessingException("Invalid GraalVM release file [" + release.toAbsolutePath() + "]");
        }
        catch (IOException e) {
            throw new AssemblerProcessingException("Invalid GraalVM release file [" + release.toAbsolutePath() + "]", (Throwable)e);
        }
    }

    private String readGraalVersion(Path path) throws AssemblerProcessingException {
        Path release = path.resolve("release");
        if (!Files.exists(release, new LinkOption[0])) {
            throw new AssemblerProcessingException("Invalid GraalVM [" + path.toAbsolutePath() + "] release file not found");
        }
        try {
            Properties props = new Properties();
            props.load(Files.newInputStream(release, new OpenOption[0]));
            if (props.containsKey(KEY_GRAALVM_VERSION)) {
                String version = props.getProperty(KEY_GRAALVM_VERSION);
                if (version.startsWith("\"") && version.endsWith("\"")) {
                    return version.substring(1, version.length() - 1);
                }
                return version;
            }
            throw new AssemblerProcessingException("Invalid GraalVM release file [" + release.toAbsolutePath() + "]");
        }
        catch (IOException e) {
            throw new AssemblerProcessingException("Invalid GraalVM release file [" + release.toAbsolutePath() + "]", (Throwable)e);
        }
    }

    private Set<Path> copyJars(JReleaserContext context, Path destination) throws AssemblerProcessingException {
        LinkedHashSet<Path> paths = new LinkedHashSet<Path>();
        paths.add(((NativeImage)this.assembler).getMainJar().getEffectivePath(context, this.assembler));
        for (Glob glob : ((NativeImage)this.assembler).getJars()) {
            glob.getResolvedArtifacts(context).stream().map(artifact -> artifact.getResolvedPath(context, this.assembler)).forEach(paths::add);
        }
        try {
            Files.createDirectories(destination, new FileAttribute[0]);
            for (Path path : paths) {
                context.getLogger().debug("copying {}", new Object[]{path.getFileName()});
                Files.copy(path, destination.resolve(path.getFileName()), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException e) {
            throw new AssemblerProcessingException("Unexpected error when copying files", (Throwable)e);
        }
        return paths;
    }

    private Set<Path> copyFiles(JReleaserContext context, Path destination) throws AssemblerProcessingException {
        LinkedHashSet<Path> paths = new LinkedHashSet<Path>();
        for (Glob glob : ((NativeImage)this.assembler).getFiles()) {
            glob.getResolvedArtifacts(context).stream().map(artifact -> artifact.getResolvedPath(context, this.assembler)).forEach(paths::add);
        }
        try {
            Files.createDirectories(destination, new FileAttribute[0]);
            for (Path path : paths) {
                context.getLogger().debug("copying {}", new Object[]{path.getFileName()});
                Files.copy(path, destination.resolve(path.getFileName()), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException e) {
            throw new AssemblerProcessingException("Unexpected error when copying files", (Throwable)e);
        }
        return paths;
    }

    @Override
    protected void writeFile(Project project, String content, Map<String, Object> props, String fileName) throws AssemblerProcessingException {
    }
}

