/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.assemblers;

import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.jreleaser.assemblers.AbstractAssemblerProcessor;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.JavaAssembler;
import org.jreleaser.model.Project;
import org.jreleaser.model.assembler.spi.AssemblerProcessingException;
import org.jreleaser.templates.TemplateUtils;
import org.jreleaser.util.JReleaserLogger;
import org.jreleaser.util.MustacheUtils;

abstract class AbstractJavaAssemblerProcessor<A extends JavaAssembler>
extends AbstractAssemblerProcessor<A> {
    protected AbstractJavaAssemblerProcessor(JReleaserContext context) {
        super(context);
    }

    @Override
    public A getAssembler() {
        return (A)((JavaAssembler)this.assembler);
    }

    @Override
    public void setAssembler(A assembler) {
        this.assembler = assembler;
    }

    @Override
    public void assemble(Map<String, Object> props) throws AssemblerProcessingException {
        try {
            this.context.getLogger().debug(RB.$((String)"tool.create.properties", (Object[])new Object[0]), new Object[]{((JavaAssembler)this.assembler).getType(), ((JavaAssembler)this.assembler).getName()});
            Map<String, Object> newProps = this.fillProps(props);
            this.context.getLogger().debug(RB.$((String)"tool.resolve.templates", (Object[])new Object[0]), new Object[]{((JavaAssembler)this.assembler).getType(), ((JavaAssembler)this.assembler).getName()});
            Map templates = TemplateUtils.resolveAndMergeTemplates((JReleaserLogger)this.context.getLogger(), (String)((JavaAssembler)this.assembler).getType(), (String)((JavaAssembler)this.assembler).getType(), (boolean)this.context.getModel().getProject().isSnapshot(), (Path)this.context.getBasedir().resolve(this.getAssembler().getTemplateDirectory()));
            for (Map.Entry entry : templates.entrySet()) {
                this.context.getLogger().debug(RB.$((String)"tool.evaluate.template", (Object[])new Object[0]), new Object[]{entry.getKey(), ((JavaAssembler)this.assembler).getName(), ((JavaAssembler)this.assembler).getType()});
                String content = MustacheUtils.applyTemplate((Reader)((Reader)entry.getValue()), newProps, (String)((String)entry.getKey()));
                this.context.getLogger().debug(RB.$((String)"tool.write.template", (Object[])new Object[0]), new Object[]{entry.getKey(), ((JavaAssembler)this.assembler).getName(), ((JavaAssembler)this.assembler).getType()});
                this.writeFile(this.context.getModel().getProject(), content, newProps, (String)entry.getKey());
            }
            Path assembleDirectory = (Path)props.get("distributionAssembleDirectory");
            Files.createDirectories(assembleDirectory, new FileAttribute[0]);
            this.doAssemble(newProps);
        }
        catch (IOException | IllegalArgumentException e) {
            throw new AssemblerProcessingException((Throwable)e);
        }
    }

    protected abstract void writeFile(Project var1, String var2, Map<String, Object> var3, String var4) throws AssemblerProcessingException;
}

