/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.disco;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.SerializationFeature;
import feign.Feign;
import feign.Request;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jreleaser.bundle.RB;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.sdk.disco.JReleaserVersion;
import org.jreleaser.sdk.disco.RestAPIException;
import org.jreleaser.sdk.disco.api.DiscoAPI;
import org.jreleaser.sdk.disco.api.EphemeralId;
import org.jreleaser.sdk.disco.api.Pkg;
import org.jreleaser.sdk.disco.api.Result;
import org.jreleaser.util.StringUtils;

public class Disco {
    private static final String ENDPOINT = "https://api.foojay.io/disco/v3.0";
    private final JReleaserLogger logger;
    private final DiscoAPI api;

    public Disco(JReleaserLogger logger, int connectTimeout, int readTimeout) {
        ObjectMapper objectMapper = new ObjectMapper().setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE).setSerializationInclusion(JsonInclude.Include.NON_NULL).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(SerializationFeature.INDENT_OUTPUT, true);
        this.logger = logger;
        this.api = (DiscoAPI)Feign.builder().encoder((Encoder)new JacksonEncoder(objectMapper)).decoder((Decoder)new JacksonDecoder(objectMapper)).requestInterceptor(template -> template.header("User-Agent", new String[]{"JReleaser/" + JReleaserVersion.getPlainVersion()})).errorDecoder((methodKey, response) -> new RestAPIException(response.request(), response.status(), response.reason(), response.headers())).options(new Request.Options((long)connectTimeout, TimeUnit.SECONDS, (long)readTimeout, TimeUnit.SECONDS, true)).target(DiscoAPI.class, ENDPOINT);
    }

    public JReleaserLogger getLogger() {
        return this.logger;
    }

    public List<Pkg> packages(Pkg pkg) throws RestAPIException {
        this.logger.debug(RB.$((String)"disco.fetch.packages", (Object[])new Object[0]), new Object[]{pkg.formatAsQuery()});
        Result<List<Pkg>> packages = this.api.packages(pkg.asQuery());
        if (packages.getResult().isEmpty()) {
            if (StringUtils.isNotBlank((String)packages.getMessage())) {
                this.logger.warn(packages.getMessage());
            } else {
                this.logger.warn(RB.$((String)"ERROR_disco_resolve_package", (Object[])new Object[]{pkg}));
            }
            return Collections.emptyList();
        }
        return packages.getResult();
    }

    public List<EphemeralId> pkg(String id) throws RestAPIException {
        this.logger.debug(RB.$((String)"disco.fetch.package", (Object[])new Object[0]), new Object[]{id});
        Result<List<EphemeralId>> ephemeralIds = this.api.ids(id);
        if (ephemeralIds.getResult().isEmpty()) {
            if (StringUtils.isNotBlank((String)ephemeralIds.getMessage())) {
                this.logger.warn(ephemeralIds.getMessage());
            } else {
                this.logger.warn(RB.$((String)"ERROR_disco_resolve_pkg", (Object[])new Object[]{id}));
            }
            return Collections.emptyList();
        }
        return ephemeralIds.getResult();
    }
}

