/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.disco.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.sdk.disco.api.Links;
import org.jreleaser.util.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Pkg {
    private String id;
    private String version;
    private String archiveType = "zip";
    private String distribution;
    private String distributionVersion;
    private String operatingSystem;
    private String architecture = "x86-64";
    private String libc_type;
    private boolean javafxBundled;
    private boolean directlyDownloadable;
    private String filename;
    private Links links;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getArchiveType() {
        return this.archiveType;
    }

    public void setArchiveType(String archiveType) {
        this.archiveType = archiveType;
    }

    public String getDistribution() {
        return this.distribution;
    }

    public void setDistribution(String distribution) {
        this.distribution = distribution;
    }

    public String getDistributionVersion() {
        return this.distributionVersion;
    }

    public void setDistributionVersion(String distributionVersion) {
        this.distributionVersion = distributionVersion;
    }

    public String getOperatingSystem() {
        return this.operatingSystem;
    }

    public void setOperatingSystem(String operatingSystem) {
        this.operatingSystem = operatingSystem;
        if ("linux_musl".equalsIgnoreCase(operatingSystem) || "alpine_linux".equalsIgnoreCase(operatingSystem)) {
            this.libc_type = "musl";
        }
        if ("linux".equalsIgnoreCase(operatingSystem)) {
            this.libc_type = "glibc";
        }
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public void setArchitecture(String architecture) {
        this.architecture = architecture;
    }

    public String getLibc_type() {
        return this.libc_type;
    }

    public void setLibc_type(String libc_type) {
        this.libc_type = libc_type;
    }

    public boolean isJavafxBundled() {
        return this.javafxBundled;
    }

    public void setJavafxBundled(boolean javafxBundled) {
        this.javafxBundled = javafxBundled;
    }

    public boolean isDirectlyDownloadable() {
        return this.directlyDownloadable;
    }

    public void setDirectlyDownloadable(boolean directlyDownloadable) {
        this.directlyDownloadable = directlyDownloadable;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public Links getLinks() {
        return this.links;
    }

    public void setLinks(Links links) {
        this.links = links;
    }

    public String formatAsQuery() {
        String s = "[version='" + this.version + '\'' + ", distribution='" + this.distribution + '\'' + ", operatingSystem='" + this.operatingSystem + '\'' + ", architecture='" + this.architecture + '\'' + ", archiveType='" + this.archiveType + '\'' + ", javafxBundled='" + this.javafxBundled + '\'' + ", packageType='jdk'";
        if (StringUtils.isNotBlank((String)this.libc_type)) {
            s = s + ", libcType='" + this.libc_type + '\'';
        }
        s = s + ']';
        return s;
    }

    public Map<String, String> asQuery() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("version", this.version);
        map.put("distribution", this.distribution);
        map.put("operating_system", this.operatingSystem);
        map.put("architecture", this.architecture);
        map.put("archive_type", this.archiveType);
        map.put("javafx_bundled", String.valueOf(this.javafxBundled));
        map.put("package_type", "jdk");
        if (StringUtils.isNotBlank((String)this.libc_type)) {
            map.put("libc_type", this.libc_type);
        }
        return map;
    }
}

