/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.engine.assemble;

import java.util.Map;
import org.jreleaser.engine.assemble.DistributionAssembler;
import org.jreleaser.model.Assemble;
import org.jreleaser.model.Assembler;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.assembler.spi.AssemblerProcessingException;

public class Assemblers {
    public static void assemble(JReleaserContext context) {
        Assemble assemble = context.getModel().getAssemble();
        if (!assemble.isEnabled()) {
            context.getLogger().info("Assembling is not enabled. Skipping.");
            return;
        }
        if (context.hasAssemblerName()) {
            Map assemblers = assemble.findAssemblersByType(context.getAssemblerName());
            if (assemblers.isEmpty()) {
                context.getLogger().debug("No assemblers match {}", new Object[]{context.getAssemblerName()});
                return;
            }
            if (context.hasDistributionName()) {
                if (!assemblers.containsKey(context.getDistributionName())) {
                    context.getLogger().error("Distribution {} is not configured for assembling with {}", new Object[]{context.getDistributionName(), context.getAssemblerName()});
                    return;
                }
                context.getLogger().info("Assembling {} distribution with {}", new Object[]{context.getDistributionName(), context.getAssemblerName()});
                Assemblers.assemble(context, (Assembler)assemblers.get(context.getDistributionName()));
            } else {
                context.getLogger().info("Assembling all distributions with {}", new Object[]{context.getAssemblerName()});
                assemblers.values().forEach(assembler -> Assemblers.assemble(context, assembler));
            }
        } else if (context.hasDistributionName()) {
            context.getLogger().info("Assembling {} distribution with all assemblers", new Object[]{context.getDistributionName()});
            assemble.findAllAssemblers().stream().filter(a -> context.getDistributionName().equals(a.getName())).forEach(assembler -> Assemblers.assemble(context, assembler));
        } else {
            context.getLogger().info("Assembling all distributions");
            assemble.findAllAssemblers().forEach(assembler -> Assemblers.assemble(context, assembler));
        }
    }

    private static void assemble(JReleaserContext context, Assembler assembler) {
        try {
            context.getLogger().increaseIndent();
            context.getLogger().setPrefix(assembler.getType());
            DistributionAssembler processor = Assemblers.createDistributionAssembler(context, assembler);
            processor.assemble();
            context.getLogger().restorePrefix();
            context.getLogger().decreaseIndent();
        }
        catch (AssemblerProcessingException e) {
            throw new JReleaserException("Unexpected error", (Throwable)e);
        }
    }

    private static DistributionAssembler createDistributionAssembler(JReleaserContext context, Assembler assembler) {
        return DistributionAssembler.builder().context(context).assembler(assembler).build();
    }
}

