/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.engine.context;

import java.nio.file.Path;
import java.util.List;
import org.jreleaser.config.JReleaserConfigLoader;
import org.jreleaser.engine.context.ModelConfigurer;
import org.jreleaser.engine.release.Releasers;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.JReleaserModel;
import org.jreleaser.util.JReleaserLogger;

public class ContextCreator {
    public static JReleaserContext create(JReleaserLogger logger, JReleaserContext.Configurer configurer, JReleaserContext.Mode mode, Path configFile, Path basedir, Path outputDirectory, boolean dryrun, boolean gitRootSearch, List<String> selectedPlatforms) {
        return ContextCreator.create(logger, configurer, mode, ContextCreator.resolveModel(logger, configFile), basedir, outputDirectory, dryrun, gitRootSearch, selectedPlatforms);
    }

    public static JReleaserContext create(JReleaserLogger logger, JReleaserContext.Configurer configurer, JReleaserContext.Mode mode, JReleaserModel model, Path basedir, Path outputDirectory, boolean dryrun, boolean gitRootSearch, List<String> selectedPlatforms) {
        JReleaserContext context = new JReleaserContext(logger, configurer, mode, model, basedir, outputDirectory, dryrun, gitRootSearch, selectedPlatforms);
        ModelConfigurer.configure(context);
        if (mode != JReleaserContext.Mode.ASSEMBLE) {
            context.setReleaser(Releasers.releaserFor(context));
        }
        ContextCreator.report(context);
        return context;
    }

    public static JReleaserModel resolveModel(JReleaserLogger logger, Path configFile) {
        try {
            logger.info("Reading configuration");
            return JReleaserConfigLoader.loadConfig((Path)configFile);
        }
        catch (JReleaserException e) {
            logger.trace((Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.trace((Throwable)e);
            throw new JReleaserException("Unexpected error when parsing configuration from " + configFile.toAbsolutePath(), (Throwable)e);
        }
    }

    private static void report(JReleaserContext context) {
        String version = context.getModel().getProject().getVersion();
        context.getModel().getProject().parseVersion();
        context.getLogger().info("Project version set to {}", new Object[]{version});
        context.getLogger().info("Release is{}snapshot", new Object[]{context.getModel().getProject().isSnapshot() ? " " : " not "});
        context.getLogger().info("Timestamp is {}", new Object[]{context.getModel().getTimestamp()});
        context.getLogger().info("HEAD is at {}", new Object[]{context.getModel().getCommit().getShortHash()});
    }
}

