/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.engine.changelog;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.jreleaser.bundle.RB;
import org.jreleaser.engine.release.Releasers;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.util.JReleaserException;

public class Changelog {
    public static String createChangelog(JReleaserContext context) {
        try {
            return Releasers.releaserFor(context).generateReleaseNotes();
        }
        catch (IOException e) {
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_error_changelog", (Object[])new Object[0]), (Throwable)e);
        }
    }

    public static String readChangelog(JReleaserContext context) {
        Path changelogFile = context.getOutputDirectory().resolve("release").resolve("CHANGELOG.md");
        if (Files.exists(changelogFile, new LinkOption[0])) {
            try {
                return new String(Files.readAllBytes(changelogFile)).trim();
            }
            catch (IOException e) {
                context.getLogger().warn(RB.$((String)"ERROR_cannot_read_changelog", (Object[])new Object[0]), new Object[]{context.relativizeToBasedir(changelogFile)});
            }
        }
        return "";
    }
}

